/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProcessEventListener;
import com.intellij.openapi.vcs.VcsException;
import git4idea.GitVcs;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerListener;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitProgressAnalyzer;
import git4idea.commands.GitTaskResult;
import git4idea.commands.GitTaskResultHandler;
import git4idea.commands.GitTaskResultHandlerAdapter;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class GitTask {
    private static final Logger LOG = Logger.getInstance(GitTask.class);
    private final Project myProject;
    private final GitHandler myHandler;
    private final String myTitle;
    private GitProgressAnalyzer myProgressAnalyzer;
    private ProgressIndicator myProgressIndicator;

    public GitTask(Project project, GitHandler handler, String title) {
        this.myProject = project;
        this.myHandler = handler;
        this.myTitle = title;
    }

    public GitTaskResult executeModal() {
        return this.execute(true);
    }

    public void executeAsync(GitTaskResultHandler resultHandler) {
        this.execute(false, false, resultHandler);
    }

    public void executeInBackground(boolean sync, GitTaskResultHandler resultHandler) {
        this.execute(sync, false, resultHandler);
    }

    @NotNull
    public GitTaskResult execute(boolean modal) {
        final AtomicReference<GitTaskResult> result = new AtomicReference<GitTaskResult>(GitTaskResult.INITIAL);
        this.execute(true, modal, new GitTaskResultHandlerAdapter(){

            @Override
            protected void run(GitTaskResult res) {
                result.set(res);
            }
        });
        GitTaskResult gitTaskResult = result.get();
        if (gitTaskResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitTask", "execute"));
        }
        return gitTaskResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(boolean sync, boolean modal, final GitTaskResultHandler resultHandler) {
        Object task;
        final Object LOCK = new Object();
        final AtomicBoolean completed = new AtomicBoolean();
        if (modal) {
            task = new ModalTask(this.myProject, this.myHandler, this.myTitle){

                public void onSuccess() {
                    GitTask.this.commonOnSuccess(LOCK, resultHandler);
                    completed.set(true);
                }

                public void onCancel() {
                    GitTask.this.commonOnCancel(LOCK, resultHandler);
                    completed.set(true);
                }

                public void onError(@NotNull Exception error) {
                    if (error == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "git4idea/commands/GitTask$2", "onError"));
                    }
                    super.onError(error);
                    GitTask.this.commonOnCancel(LOCK, resultHandler);
                    completed.set(true);
                }
            };
            ApplicationManager.getApplication().invokeAndWait(() -> GitTask.lambda$execute$0((ModalTask)task));
        } else {
            task = new BackgroundableTask(this.myProject, this.myHandler, this.myTitle){

                public void onSuccess() {
                    GitTask.this.commonOnSuccess(LOCK, resultHandler);
                    completed.set(true);
                }

                public void onCancel() {
                    GitTask.this.commonOnCancel(LOCK, resultHandler);
                    completed.set(true);
                }
            };
            if (this.myProgressIndicator == null) {
                GitVcs.runInBackground((Task.Backgroundable)task);
            } else {
                ((BackgroundableTask)task).runAlone();
            }
        }
        if (sync) {
            while (!completed.get()) {
                try {
                    task = LOCK;
                    synchronized (task) {
                        LOCK.wait(50L);
                    }
                }
                catch (InterruptedException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonOnSuccess(Object LOCK, GitTaskResultHandler resultHandler) {
        GitTaskResult res = !this.myHandler.errors().isEmpty() ? GitTaskResult.GIT_ERROR : GitTaskResult.OK;
        resultHandler.run(res);
        Object object = LOCK;
        synchronized (object) {
            LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonOnCancel(Object LOCK, GitTaskResultHandler resultHandler) {
        resultHandler.run(GitTaskResult.CANCELLED);
        Object object = LOCK;
        synchronized (object) {
            LOCK.notifyAll();
        }
    }

    private void addListeners(final TaskExecution task, final ProgressIndicator indicator) {
        if (indicator != null) {
            indicator.setIndeterminate(this.myProgressAnalyzer == null);
        }
        GitLineHandlerListener listener = new GitLineHandlerListener(){

            public void processTerminated(int exitCode) {
                if (exitCode != 0 && !GitTask.this.myHandler.isIgnoredErrorCode(exitCode) && GitTask.this.myHandler.errors().isEmpty()) {
                    GitTask.this.myHandler.addError(new VcsException(GitTask.this.myHandler.getLastOutput()));
                }
            }

            public void startFailed(Throwable exception) {
                GitTask.this.myHandler.addError(new VcsException("Git start failed: " + exception.getMessage(), exception));
            }

            @Override
            public void onLineAvailable(String line, Key outputType) {
                double fraction;
                if (GitHandlerUtil.isErrorLine(line.trim())) {
                    GitTask.this.myHandler.addError(new VcsException(line));
                } else if (!StringUtil.isEmptyOrSpaces((String)line)) {
                    GitTask.this.myHandler.addLastOutput(line);
                }
                if (indicator != null) {
                    indicator.setText2(line);
                }
                if (GitTask.this.myProgressAnalyzer != null && indicator != null && (fraction = GitTask.this.myProgressAnalyzer.analyzeProgress(line)) >= 0.0) {
                    indicator.setFraction(fraction);
                }
            }
        };
        if (this.myHandler instanceof GitLineHandler) {
            ((GitLineHandler)this.myHandler).addLineListener(listener);
        } else {
            this.myHandler.addListener((ProcessEventListener)listener);
        }
        this.myHandler.addListener(new GitHandlerListener(){

            public void processTerminated(int exitCode) {
                task.dispose();
            }

            public void startFailed(Throwable exception) {
                task.dispose();
            }
        });
    }

    public void setProgressAnalyzer(GitProgressAnalyzer progressAnalyzer) {
        this.myProgressAnalyzer = progressAnalyzer;
    }

    public void setProgressIndicator(ProgressIndicator progressIndicator) {
        this.myProgressIndicator = progressIndicator;
    }

    private static /* synthetic */ void lambda$execute$0(ModalTask task) {
        ProgressManager.getInstance().run((Task)task);
    }

    private static class GitTaskDelegate
    implements Disposable {
        private final GitHandler myHandler;
        private ProgressIndicator myIndicator;
        private final TaskExecution myTask;
        private ScheduledFuture<?> myTimer;
        private final Project myProject;

        public GitTaskDelegate(Project project, GitHandler handler, TaskExecution task) {
            this.myProject = project;
            this.myHandler = handler;
            this.myTask = task;
            Disposer.register((Disposable)this.myProject, (Disposable)this);
        }

        public void run(ProgressIndicator indicator) {
            this.myIndicator = indicator;
            this.myTimer = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
                if (this.myIndicator != null && this.myIndicator.isCanceled()) {
                    try {
                        if (this.myHandler != null) {
                            this.myHandler.destroyProcess();
                        }
                    }
                    finally {
                        Disposer.dispose((Disposable)this);
                    }
                }
            }, 0L, 200L, TimeUnit.MILLISECONDS);
            this.myTask.execute(indicator);
        }

        public void dispose() {
            if (this.myTimer != null) {
                this.myTimer.cancel(false);
            }
        }
    }

    private abstract class ModalTask
    extends Task.Modal
    implements TaskExecution {
        private final GitTaskDelegate myDelegate;

        public ModalTask(@NotNull Project project, @NotNull GitHandler handler, String processTitle) {
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "git4idea/commands/GitTask$ModalTask", "<init>"));
            }
            if (processTitle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processTitle", "git4idea/commands/GitTask$ModalTask", "<init>"));
            }
            super(project, processTitle, true);
            this.myDelegate = new GitTaskDelegate(this.myProject, handler, this);
        }

        public final void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/commands/GitTask$ModalTask", "run"));
            }
            this.myDelegate.run(indicator);
        }

        @Override
        public void execute(ProgressIndicator indicator) {
            GitTask.this.addListeners(this, indicator);
            GitHandlerUtil.runInCurrentThread(GitTask.this.myHandler, indicator, false, this.myTitle);
        }

        @Override
        public void dispose() {
            Disposer.dispose((Disposable)this.myDelegate);
        }
    }

    private abstract class BackgroundableTask
    extends Task.Backgroundable
    implements TaskExecution {
        private final GitTaskDelegate myDelegate;

        public BackgroundableTask(@NotNull Project project, @NotNull GitHandler handler, String processTitle) {
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "git4idea/commands/GitTask$BackgroundableTask", "<init>"));
            }
            if (processTitle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processTitle", "git4idea/commands/GitTask$BackgroundableTask", "<init>"));
            }
            super(project, processTitle, true);
            this.myDelegate = new GitTaskDelegate(this.myProject, handler, this);
        }

        public final void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/commands/GitTask$BackgroundableTask", "run"));
            }
            this.myDelegate.run(indicator);
        }

        public final void runAlone() {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        BackgroundableTask.this.justRun();
                    }
                });
            } else {
                this.justRun();
            }
        }

        private void justRun() {
            String oldTitle = GitTask.this.myProgressIndicator.getText();
            GitTask.this.myProgressIndicator.setText(this.myTitle);
            this.myDelegate.run(GitTask.this.myProgressIndicator);
            GitTask.this.myProgressIndicator.setText(oldTitle);
            if (GitTask.this.myProgressIndicator.isCanceled()) {
                this.onCancel();
            } else {
                this.onSuccess();
            }
        }

        @Override
        public void execute(ProgressIndicator indicator) {
            GitTask.this.addListeners(this, indicator);
            GitHandlerUtil.runInCurrentThread(GitTask.this.myHandler, indicator, false, this.myTitle);
        }

        @Override
        public void dispose() {
            Disposer.dispose((Disposable)this.myDelegate);
        }
    }

    private static interface TaskExecution {
        public void execute(ProgressIndicator var1);

        public void dispose();
    }
}

