/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkout;

import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.dvcs.ui.CloneDvcsDialog;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.remote.GitRememberedInputs;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCloneDialog
extends CloneDvcsDialog {
    @NotNull
    private final Git myGit;

    public GitCloneDialog(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkout/GitCloneDialog", "<init>"));
        }
        this(project, null);
    }

    public GitCloneDialog(@NotNull Project project, @Nullable String defaultUrl) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkout/GitCloneDialog", "<init>"));
        }
        super(project, "Git", ".git", defaultUrl);
        this.myGit = (Git)ServiceManager.getService(Git.class);
    }

    @NotNull
    protected CloneDvcsDialog.TestResult test(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/checkout/GitCloneDialog", "test"));
        }
        GitCommandResult result = this.myGit.lsRemote(this.myProject, new File("."), url);
        CloneDvcsDialog.TestResult testResult = result.success() ? CloneDvcsDialog.TestResult.SUCCESS : new CloneDvcsDialog.TestResult(result.getErrorOutputAsJoinedString());
        if (testResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkout/GitCloneDialog", "test"));
        }
        return testResult;
    }

    @NotNull
    protected DvcsRememberedInputs getRememberedInputs() {
        DvcsRememberedInputs dvcsRememberedInputs = GitRememberedInputs.getInstance();
        if (dvcsRememberedInputs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkout/GitCloneDialog", "getRememberedInputs"));
        }
        return dvcsRememberedInputs;
    }

    protected String getDimensionServiceKey() {
        return "GitCloneDialog";
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.CloneRepository";
    }
}

