/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class UnresolvedMergeCheckFactory
extends CheckinHandlerFactory {
    @NotNull
    public CheckinHandler createHandler(final @NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "git4idea/checkin/UnresolvedMergeCheckFactory", "createHandler"));
        }
        if (commitContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitContext", "git4idea/checkin/UnresolvedMergeCheckFactory", "createHandler"));
        }
        CheckinHandler checkinHandler = new CheckinHandler(){

            public CheckinHandler.ReturnResult beforeCheckin() {
                if (UnresolvedMergeCheckFactory.containsUnresolvedConflicts(panel)) {
                    int answer = Messages.showYesNoDialog((Component)panel.getComponent(), (String)"Are you sure you want to commit changes with unresolved conflicts?", (String)"Unresolved Conflicts", (Icon)Messages.getWarningIcon());
                    return answer == 0 ? CheckinHandler.ReturnResult.COMMIT : CheckinHandler.ReturnResult.CANCEL;
                }
                return CheckinHandler.ReturnResult.COMMIT;
            }
        };
        if (checkinHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/UnresolvedMergeCheckFactory", "createHandler"));
        }
        return checkinHandler;
    }

    private static boolean containsUnresolvedConflicts(@NotNull CheckinProjectPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "git4idea/checkin/UnresolvedMergeCheckFactory", "containsUnresolvedConflicts"));
        }
        for (Change change : panel.getSelectedChanges()) {
            FileStatus status = change.getFileStatus();
            if (!status.equals(FileStatus.MERGE) && !status.equals(FileStatus.MERGED_WITH_BOTH_CONFLICTS) && !status.equals(FileStatus.MERGED_WITH_CONFLICTS) && !status.equals(FileStatus.MERGED_WITH_PROPERTY_CONFLICTS)) continue;
            return true;
        }
        return false;
    }
}

