/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import git4idea.GitVcs;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import org.jetbrains.annotations.NotNull;

public class GitRepositoryForAnnotationsListener {
    private final Project myProject;
    private final GitRepositoryChangeListener myListener;
    private ProjectLevelVcsManager myVcsManager;
    private GitVcs myVcs;

    public GitRepositoryForAnnotationsListener(Project project) {
        this.myProject = project;
        this.myListener = this.createListener();
        this.myVcs = GitVcs.getInstance(this.myProject);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        project.getMessageBus().connect().subscribe(GitRepository.GIT_REPO_CHANGE, (Object)this.myListener);
    }

    private GitRepositoryChangeListener createListener() {
        return new GitRepositoryChangeListener(){

            @Override
            public void repositoryChanged(@NotNull GitRepository repository) {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/annotate/GitRepositoryForAnnotationsListener$1", "repositoryChanged"));
                }
                VcsAnnotationRefresher refresher = (VcsAnnotationRefresher)GitRepositoryForAnnotationsListener.this.myProject.getMessageBus().syncPublisher(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED);
                refresher.dirtyUnder(repository.getRoot());
            }
        };
    }
}

