/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclarationUtil;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

public class ResolveSessionUtils {
    private ResolveSessionUtils() {
    }

    @NotNull
    public static Collection<ClassDescriptor> getClassDescriptorsByFqName(@NotNull ModuleDescriptor module, @NotNull FqName fqName2) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "getClassDescriptorsByFqName"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "getClassDescriptorsByFqName"));
        }
        Collection<ClassDescriptor> collection = ResolveSessionUtils.getClassOrObjectDescriptorsByFqName(module, fqName2, Predicates.<ClassDescriptor>alwaysTrue());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "getClassDescriptorsByFqName"));
        }
        return collection;
    }

    @NotNull
    public static Collection<ClassDescriptor> getClassOrObjectDescriptorsByFqName(@NotNull ModuleDescriptor module, @NotNull FqName fqName2, @NotNull Predicate<ClassDescriptor> filter2) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
        }
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
        }
        if (fqName2.isRoot()) {
            List<ClassDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
            }
            return list2;
        }
        ArrayList<ClassDescriptor> result2 = new ArrayList<ClassDescriptor>(1);
        FqName packageFqName = fqName2.parent();
        while (true) {
            PackageViewDescriptor packageDescriptor;
            if (!(packageDescriptor = module.getPackage(packageFqName)).isEmpty()) {
                FqName relativeClassFqName = FqNamesUtilKt.tail(fqName2, packageFqName);
                ClassDescriptor classDescriptor = ResolveSessionUtils.findClassByRelativePath(packageDescriptor.getMemberScope(), relativeClassFqName);
                if (classDescriptor != null && filter2.apply(classDescriptor)) {
                    result2.add(classDescriptor);
                }
            }
            if (packageFqName.isRoot()) break;
            packageFqName = packageFqName.parent();
        }
        ArrayList<ClassDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
        }
        return arrayList;
    }

    @Nullable
    public static ClassDescriptor findClassByRelativePath(@NotNull MemberScope packageScope, @NotNull FqName path) {
        if (packageScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageScope", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "findClassByRelativePath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "findClassByRelativePath"));
        }
        if (path.isRoot()) {
            return null;
        }
        MemberScope scope = packageScope;
        ClassifierDescriptor classifier2 = null;
        for (Name name : path.pathSegments()) {
            classifier2 = scope.getContributedClassifier(name, NoLookupLocation.WHEN_FIND_BY_FQNAME);
            if (!(classifier2 instanceof ClassDescriptor)) {
                return null;
            }
            scope = ((ClassDescriptor)classifier2).getUnsubstitutedInnerClassesScope();
        }
        return (ClassDescriptor)classifier2;
    }

    @NotNull
    public static Name safeNameForLazyResolve(@NotNull KtNamedDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "safeNameForLazyResolve"));
        }
        Name name = ResolveSessionUtils.safeNameForLazyResolve(declaration.getNameAsName());
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "safeNameForLazyResolve"));
        }
        return name;
    }

    @NotNull
    public static Name safeNameForLazyResolve(@Nullable Name name) {
        Name name2 = SpecialNames.safeIdentifier(name);
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "safeNameForLazyResolve"));
        }
        return name2;
    }

    @Nullable
    public static FqName safeFqNameForLazyResolve(@NotNull KtNamedDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "safeFqNameForLazyResolve"));
        }
        FqName parentFqName = KtNamedDeclarationUtil.getParentFqName(declaration);
        return parentFqName != null ? parentFqName.child(ResolveSessionUtils.safeNameForLazyResolve(declaration)) : null;
    }
}

