/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.connection;

import com.heroku.api.Heroku;
import com.heroku.api.connection.AsyncConnection;
import com.heroku.api.connection.Connection;
import com.heroku.api.connection.ConnectionProvider;
import com.heroku.api.exception.HerokuAPIException;
import com.heroku.api.http.Http;
import com.heroku.api.request.Request;
import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class JerseyClientAsyncConnection
implements AsyncConnection<Future<?>> {
    private final Client client;
    private Integer myRemainingRateLimit;

    public JerseyClientAsyncConnection() {
        this(Client.create());
    }

    public JerseyClientAsyncConnection(Client client) {
        this.client = client;
    }

    public <T> Future<T> executeAsync(final Request<T> request, String apiKey) {
        AsyncWebResource resource = this.client.asyncResource(Heroku.Config.ENDPOINT.value + request.getEndpoint());
        resource.addFilter((ClientFilter)new HTTPBasicAuthFilter("", apiKey));
        AsyncWebResource.Builder builder = resource.getRequestBuilder();
        builder.header(request.getResponseType().getHeaderName(), (Object)request.getResponseType().getHeaderValue());
        builder.header("X-Heroku-API-Version", (Object)String.valueOf(Heroku.ApiVersion.v2.version));
        builder.header(Http.UserAgent.LATEST.getHeaderName(), (Object)Http.UserAgent.LATEST.getHeaderValue("jersey-client"));
        for (Map.Entry header : request.getHeaders().entrySet()) {
            builder.header((String)header.getKey(), header.getValue());
        }
        if (request.hasBody()) {
            builder.entity((Object)request.getBody());
        }
        final Future futureResponse = builder.method(request.getHttpMethod().name(), ClientResponse.class);
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return futureResponse.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return futureResponse.isCancelled();
            }

            @Override
            public boolean isDone() {
                return futureResponse.isDone();
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                return this.handleResponse((ClientResponse)futureResponse.get());
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.handleResponse((ClientResponse)futureResponse.get(timeout, unit));
            }

            private T handleResponse(ClientResponse r) {
                String header = (String)r.getHeaders().getFirst((Object)"X-RateLimit-Remaining");
                try {
                    JerseyClientAsyncConnection.this.myRemainingRateLimit = header == null ? null : Integer.valueOf(Integer.parseInt(header));
                }
                catch (NumberFormatException e) {
                    JerseyClientAsyncConnection.this.myRemainingRateLimit = null;
                }
                return request.getResponse((byte[])r.getEntity(byte[].class), r.getStatus());
            }
        };
    }

    public <T> Future<T> executeAsync(final Request<T> request, Map<String, String> extraHeaders, String apiKey) {
        AsyncWebResource resource = this.client.asyncResource(Heroku.Config.ENDPOINT.value + request.getEndpoint());
        resource.addFilter((ClientFilter)new HTTPBasicAuthFilter("", apiKey));
        AsyncWebResource.Builder builder = resource.getRequestBuilder();
        builder.header(request.getResponseType().getHeaderName(), (Object)request.getResponseType().getHeaderValue());
        builder.header("X-Heroku-API-Version", (Object)String.valueOf(Heroku.ApiVersion.v2.version));
        builder.header(Http.UserAgent.LATEST.getHeaderName(), (Object)Http.UserAgent.LATEST.getHeaderValue("jersey-client"));
        for (Map.Entry header : request.getHeaders().entrySet()) {
            builder.header((String)header.getKey(), header.getValue());
        }
        if (request.hasBody()) {
            builder.entity((Object)request.getBody());
        }
        final Future futureResponse = builder.method(request.getHttpMethod().name(), ClientResponse.class);
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return futureResponse.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return futureResponse.isCancelled();
            }

            @Override
            public boolean isDone() {
                return futureResponse.isDone();
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                return this.handleResponse((ClientResponse)futureResponse.get());
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.handleResponse((ClientResponse)futureResponse.get(timeout, unit));
            }

            private T handleResponse(ClientResponse r) {
                return request.getResponse((byte[])r.getEntity(byte[].class), r.getStatus());
            }
        };
    }

    public <T> T execute(Request<T> request, String key) {
        try {
            return (T)this.executeAsync((Request)request, key).get();
        }
        catch (InterruptedException e) {
            throw new HerokuAPIException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new HerokuAPIException((Throwable)e);
        }
    }

    public <T> T execute(Request<T> request, Map<String, String> extraHeaders, String key) {
        try {
            return (T)this.executeAsync((Request)request, (Map)extraHeaders, key).get();
        }
        catch (InterruptedException e) {
            throw new HerokuAPIException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new HerokuAPIException((Throwable)e);
        }
    }

    public void close() {
        this.client.destroy();
    }

    public Integer getRemainingRateLimit() {
        return this.myRemainingRateLimit;
    }

    public static class Provider
    implements ConnectionProvider {
        public Connection getConnection() {
            return new JerseyClientAsyncConnection();
        }
    }
}

