/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight;

import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryResolver;
import com.intellij.execution.junit.JUnitExternalLibraryDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitExternalLibraryResolver
extends ExternalLibraryResolver {
    private static final Set<String> JUNIT4_ANNOTATIONS = ContainerUtil.set((Object[])new String[]{"Test", "Ignore", "RunWith", "Before", "BeforeClass", "After", "AfterClass"});

    @Nullable
    public ExternalLibraryResolver.ExternalClassResolveResult resolveClass(@NotNull String shortClassName, @NotNull ThreeState isAnnotation, @NotNull Module contextModule) {
        if (shortClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortClassName", "com/intellij/execution/junit/codeInsight/JUnitExternalLibraryResolver", "resolveClass"));
        }
        if (isAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isAnnotation", "com/intellij/execution/junit/codeInsight/JUnitExternalLibraryResolver", "resolveClass"));
        }
        if (contextModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextModule", "com/intellij/execution/junit/codeInsight/JUnitExternalLibraryResolver", "resolveClass"));
        }
        if ("TestCase".equals(shortClassName)) {
            return new ExternalLibraryResolver.ExternalClassResolveResult("junit.framework.TestCase", JUnitExternalLibraryDescriptor.JUNIT3);
        }
        if (isAnnotation == ThreeState.YES && JUNIT4_ANNOTATIONS.contains(shortClassName)) {
            return new ExternalLibraryResolver.ExternalClassResolveResult("org.junit." + shortClassName, JUnitExternalLibraryDescriptor.JUNIT4);
        }
        return null;
    }

    @Nullable
    public ExternalLibraryDescriptor resolvePackage(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/execution/junit/codeInsight/JUnitExternalLibraryResolver", "resolvePackage"));
        }
        if (packageName.equals("org.junit")) {
            return JUnitExternalLibraryDescriptor.JUNIT4;
        }
        if (packageName.equals("junit.framework")) {
            return JUnitExternalLibraryDescriptor.JUNIT3;
        }
        return null;
    }
}

