/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.structure;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.xml.XmlStructureViewBuilderProvider;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.model.xml.ActionState;
import com.intellij.spring.webflow.model.xml.BeanImport;
import com.intellij.spring.webflow.model.xml.Binding;
import com.intellij.spring.webflow.model.xml.DecisionState;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.If;
import com.intellij.spring.webflow.model.xml.Input;
import com.intellij.spring.webflow.model.xml.Output;
import com.intellij.spring.webflow.model.xml.Secured;
import com.intellij.spring.webflow.model.xml.SubflowState;
import com.intellij.spring.webflow.model.xml.Var;
import com.intellij.spring.webflow.model.xml.ViewState;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.structure.DomStructureTreeElement;
import com.intellij.util.xml.structure.DomStructureViewBuilder;
import com.intellij.util.xml.structure.DomStructureViewTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowStructureViewBuilderProvider
implements XmlStructureViewBuilderProvider {
    private static final ConstantFunction<DomElement, DomService.StructureViewMode> ALWAYS_SHOW = new ConstantFunction((Object)DomService.StructureViewMode.SHOW);
    public static final String FILTER_STATES_ONLY = "States only";

    public StructureViewBuilder createStructureViewBuilder(final @NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/webflow/structure/WebflowStructureViewBuilderProvider", "createStructureViewBuilder"));
        }
        if (file instanceof JspFile) {
            return null;
        }
        DomFileElement fileElement = DomManager.getDomManager((Project)file.getProject()).getFileElement(file, Flow.class);
        if (fileElement == null) {
            return null;
        }
        return new DomStructureViewBuilder(file, (Function)ALWAYS_SHOW){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                MyStructureViewTreeModel myStructureViewTreeModel = new MyStructureViewTreeModel(file, ALWAYS_SHOW, editor);
                if (myStructureViewTreeModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/structure/WebflowStructureViewBuilderProvider$1", "createStructureViewModel"));
                }
                return myStructureViewTreeModel;
            }
        };
    }

    private static class MyStructureViewTreeModel
    extends DomStructureViewTreeModel
    implements StructureViewModel.ElementInfoProvider {
        private MyStructureViewTreeModel(XmlFile file, ConstantFunction<DomElement, DomService.StructureViewMode> function, @Nullable Editor editor) {
            super(file, function, editor);
        }

        public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
            return false;
        }

        public boolean isAlwaysLeaf(StructureViewTreeElement element) {
            return MyStructureViewTreeModel.isDomElementOfKind(element, BeanImport.class, Binding.class, If.class, Input.class, Output.class, Secured.class, Var.class);
        }

        @NotNull
        public Filter[] getFilters() {
            Filter[] filterArray = new Filter[]{new Filter(){

                public boolean isVisible(TreeElement treeNode) {
                    DomStructureTreeElement domStructureTreeElement = (DomStructureTreeElement)treeNode;
                    return MyStructureViewTreeModel.isDomElementOfKind((StructureViewTreeElement)domStructureTreeElement, new Class[]{ActionState.class, DecisionState.class, SubflowState.class, ViewState.class});
                }

                public boolean isReverted() {
                    return false;
                }

                @NotNull
                public ActionPresentation getPresentation() {
                    ActionPresentationData actionPresentationData = new ActionPresentationData("States", "Show states only", AllIcons.Toolbar.Folders);
                    if (actionPresentationData == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/structure/WebflowStructureViewBuilderProvider$MyStructureViewTreeModel$1", "getPresentation"));
                    }
                    return actionPresentationData;
                }

                @NotNull
                public String getName() {
                    if (WebflowStructureViewBuilderProvider.FILTER_STATES_ONLY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/structure/WebflowStructureViewBuilderProvider$MyStructureViewTreeModel$1", "getName"));
                    }
                    return WebflowStructureViewBuilderProvider.FILTER_STATES_ONLY;
                }
            }};
            if (filterArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/structure/WebflowStructureViewBuilderProvider$MyStructureViewTreeModel", "getFilters"));
            }
            return filterArray;
        }

        private static boolean isDomElementOfKind(StructureViewTreeElement element, Class ... kinds) {
            DomElement domElement = ((DomStructureTreeElement)element).getElement();
            for (Class clazz : kinds) {
                if (!clazz.isInstance(domElement)) continue;
                return true;
            }
            return false;
        }
    }
}

