/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.xml.impl;

import com.intellij.openapi.module.Module;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.Identified;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FlowImpl
implements Flow {
    @Override
    @Nullable
    public Identified determineStartState() {
        Identified value = (Identified)this.getStartStateAttr().getValue();
        if (value != null) {
            return value;
        }
        List children = DomUtil.getDefinedChildren((DomElement)this, (boolean)true, (boolean)false);
        for (DomElement child : children) {
            if (!(child instanceof Identified)) continue;
            return (Identified)child;
        }
        return null;
    }

    @Override
    @NotNull
    public List<Flow> getAllParentFlows() {
        SmartList list = new SmartList();
        FlowImpl.addParents((Flow)DomUtil.getOriginalElement((DomElement)this), (List<Flow>)new SmartList(), (List<Flow>)list);
        SmartList smartList = list;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/xml/impl/FlowImpl", "getAllParentFlows"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public List<Flow> getInheritingFlows() {
        Module module = this.getModule();
        if (module == null) {
            List<Flow> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/xml/impl/FlowImpl", "getInheritingFlows"));
            }
            return list;
        }
        Flow me = (Flow)DomUtil.getOriginalElement((DomElement)this);
        List<WebflowModel> allModels = WebflowDomModelManager.getInstance(this.getManager().getProject()).getAllModels(module);
        SmartList result = new SmartList();
        for (WebflowModel model : allModels) {
            Flow flow = model.getFlow();
            List<Flow> parentFlows = flow.getAllParentFlows();
            if (!parentFlows.contains(me)) continue;
            result.add(flow);
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/xml/impl/FlowImpl", "getInheritingFlows"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public List<Flow> getAllRelatedFlows() {
        List<Flow> relatedFlows = this.getAllParentFlows();
        relatedFlows.addAll(this.getInheritingFlows());
        List<Flow> list = relatedFlows;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/xml/impl/FlowImpl", "getAllRelatedFlows"));
        }
        return list;
    }

    private static void addParents(Flow flow, List<Flow> visited, List<Flow> result) {
        visited.add(flow);
        List parents = (List)flow.getParentFlow().getValue();
        if (parents != null) {
            for (Flow parentFlow : parents) {
                if (visited.contains(parentFlow)) continue;
                result.add(parentFlow);
                FlowImpl.addParents(parentFlow, visited, result);
            }
        }
    }
}

