/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram.editor;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.webflow.diagram.WebflowDiagramDataModel;
import com.intellij.spring.webflow.diagram.beans.WebflowDiagramEdge;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowDomElementWrapper;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentation;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class DeleteElementAction
extends DiagramAction {
    public DeleteElementAction() {
        super("Delete Element", "Delete Selected Element", null);
    }

    public boolean isEnabled(AnActionEvent e, DiagramBuilder b) {
        return !b.isPopupMode() && DeleteElementAction.getSelectedDomElement(e) != null;
    }

    public PsiFile[] getAffectedFiles(AnActionEvent e) {
        WebflowDiagramDataModel model = (WebflowDiagramDataModel)DiagramAction.getDataModel((AnActionEvent)e);
        assert (model != null);
        return model.getAffectedFiles();
    }

    public void perform(AnActionEvent e) {
        DomElement element = DeleteElementAction.getSelectedDomElement(e);
        assert (element != null);
        ElementPresentation presentation = element.getPresentation();
        String elementName = presentation.getElementName();
        String typeName = presentation.getTypeName();
        String elementDescription = typeName + (elementName != null ? " '" + elementName + "'" : "");
        int result = Messages.showOkCancelDialog((String)("Do you really want to delete " + elementDescription + " ?"), (String)("Delete " + typeName), (Icon)Messages.getWarningIcon());
        if (result == 0) {
            DiagramBuilder builder = DeleteElementAction.getBuilder((AnActionEvent)e);
            assert (builder != null);
            DiagramAction.performCommand((DiagramBuilder)builder, () -> {
                element.undefine();
                builder.getDataModel().refreshDataModel();
            }, (String)("Delete " + elementDescription), null, (PsiElement[])new PsiElement[]{DomUtil.getFile((DomElement)element)});
        }
    }

    public String getActionName() {
        return this.getTemplatePresentation().getText();
    }

    @Nullable
    private static DomElement getSelectedDomElement(AnActionEvent e) {
        DomElement nodeElement = DeleteElementAction.getSelectedNodeDomElement(e);
        if (nodeElement != null) {
            return nodeElement;
        }
        return DeleteElementAction.getSelectedEdgeDomElement(e);
    }

    @Nullable
    private static DomElement getSelectedNodeDomElement(AnActionEvent e) {
        List nodes = DeleteElementAction.getSelectedNodesExceptNotes((AnActionEvent)e);
        if (nodes.size() != 1) {
            return null;
        }
        WebflowDomElementWrapper wrapper = (WebflowDomElementWrapper)((DiagramNode)nodes.get(0)).getIdentifyingElement();
        return wrapper.getElement();
    }

    @Nullable
    private static DomElement getSelectedEdgeDomElement(AnActionEvent e) {
        List edges = DiagramUtils.getSelectedEdges((DiagramBuilder)DeleteElementAction.getBuilder((AnActionEvent)e));
        if (edges.size() != 1) {
            return null;
        }
        DiagramEdge edge = (DiagramEdge)edges.get(0);
        if (edge instanceof WebflowDiagramEdge) {
            return ((WebflowDiagramEdge)edge).getDefiningElement();
        }
        return null;
    }
}

