/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram.beans.wrappers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowElementWrapper;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowModuleWrapper
extends WebflowElementWrapper<Module> {
    @NotNull
    private final Module myElement;

    public WebflowModuleWrapper(@NotNull Module element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowModuleWrapper", "<init>"));
        }
        this.myElement = element;
    }

    @Override
    @NotNull
    public Module getElement() {
        Module module = this.myElement;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowModuleWrapper", "getElement"));
        }
        return module;
    }

    @Override
    @NotNull
    public String getName() {
        String string = "Module " + this.myElement.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowModuleWrapper", "getName"));
        }
        return string;
    }

    @Override
    public String getFqn() {
        return this.myElement.getName();
    }

    @Override
    @NotNull
    public List<WebflowModel> getFlowModels() {
        List<WebflowModel> list = WebflowDomModelManager.getInstance(this.myElement.getProject()).getAllModels(this.myElement);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowModuleWrapper", "getFlowModels"));
        }
        return list;
    }

    @Nullable
    public static WebflowElementWrapper resolveElementByFQN(String fqn, Project project) {
        Module module = ModuleManager.getInstance((Project)project).findModuleByName(fqn);
        if (module == null) {
            return null;
        }
        return new WebflowModuleWrapper(module);
    }
}

