/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram.beans.wrappers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowElementWrapper;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowFlowWrapper
extends WebflowElementWrapper<XmlFile> {
    private static final String PATH = "flowPath";
    @Nullable
    private final WebflowModel myModel;
    @NotNull
    private final XmlFile myElement;

    public WebflowFlowWrapper(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowFlowWrapper", "<init>"));
        }
        this.myElement = file;
        this.myModel = WebflowDomModelManager.getInstance(this.myElement.getProject()).getWebflowModel(this.myElement);
    }

    @Override
    @NotNull
    public XmlFile getElement() {
        XmlFile xmlFile = this.myElement;
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowFlowWrapper", "getElement"));
        }
        return xmlFile;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myElement.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowFlowWrapper", "getName"));
        }
        return string;
    }

    @Override
    public String getFqn() {
        VirtualFile virtualFile = this.myElement.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return "flowPath=" + virtualFile.getPath();
    }

    @Override
    @NotNull
    public List<WebflowModel> getFlowModels() {
        if (!this.myElement.isValid()) {
            List<WebflowModel> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowFlowWrapper", "getFlowModels"));
            }
            return list;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)this.myModel);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowFlowWrapper", "getFlowModels"));
        }
        return list;
    }

    @Nullable
    public static WebflowElementWrapper resolveElementByFQN(String fqn, Project project) {
        String path = WebflowFlowWrapper.split(fqn).get(PATH);
        XmlFile file = WebflowFlowWrapper.findFile(project, path);
        if (file == null) {
            return null;
        }
        return new WebflowFlowWrapper(file);
    }

    @Nullable
    private static XmlFile findFile(@NotNull Project project, @Nullable String path) {
        PsiFile psiFile;
        VirtualFile relativeFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowFlowWrapper", "findFile"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)path) && (relativeFile = VfsUtil.findRelativeFile((String)path, null)) != null && (psiFile = PsiManager.getInstance((Project)project).findFile(relativeFile)) instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return null;
    }
}

