/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.actions;

import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.webflow.model.WebflowVersion;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.spring.webflow.util.WebflowVersionDetector;
import icons.SpringWebflowIcons;
import org.jetbrains.annotations.NotNull;

public class CreateWebflowFileAction
extends CreateFileAction {
    public CreateWebflowFileAction() {
        super(WebflowBundle.message("flow.new.file", new Object[0]), WebflowBundle.message("flow.new.file.description", new Object[0]), SpringWebflowIcons.SpringWebFlowFile);
    }

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        return SpringCommonUtils.hasSpringFacet((Module)module) && WebflowUtil.isWebFlowAvailable(module);
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)directory);
        assert (module != null) : directory;
        WebflowVersion webflowVersion = WebflowVersionDetector.detect(module);
        String templateName = webflowVersion.isAtLeast(WebflowVersion.Webflow_2_0) ? (webflowVersion.isAtLeast(WebflowVersion.Webflow_2_4) ? "webflow.2_4.xml" : "webflow.2_0.xml") : "webflow.1_0.xml";
        FileTemplate template = FileTemplateManager.getInstance((Project)directory.getProject()).getJ2eeTemplate(templateName);
        String fileName = this.getFileName(newName);
        PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, null, (PsiDirectory)directory);
        PsiElement[] psiElementArray = new PsiElement[]{psiElement};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/actions/CreateWebflowFileAction", "create"));
        }
        return psiElementArray;
    }

    protected String getDefaultExtension() {
        return "xml";
    }
}

