/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.psi;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageASTFactory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILeafElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.haml.HAMLFileType;

public final class HamlWrapperTokenType
extends IElementType
implements ILeafElementType {
    @NotNull
    private final IElementType myDelegate;
    @NotNull
    private final String myDefaultText;

    public HamlWrapperTokenType(@NotNull IElementType delegate, @NotNull CharSequence defaultText) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/plugins/haml/psi/HamlWrapperTokenType", "<init>"));
        }
        if (defaultText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultText", "org/jetbrains/plugins/haml/psi/HamlWrapperTokenType", "<init>"));
        }
        super("Wrapper (" + delegate + ")", HAMLFileType.HAML.getLanguage());
        this.myDelegate = delegate;
        this.myDefaultText = defaultText.toString();
    }

    @NotNull
    public ASTNode createLeafNode(@Nullable CharSequence leafText) {
        if (leafText == null) {
            leafText = this.myDefaultText;
        }
        ASTFactory factory = (ASTFactory)LanguageASTFactory.INSTANCE.forLanguage(this.myDelegate.getLanguage());
        assert (factory != null);
        LeafElement customLeaf = factory.createLeaf(this.myDelegate, leafText);
        if (customLeaf != null) {
            LeafElement leafElement = customLeaf;
            if (leafElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/psi/HamlWrapperTokenType", "createLeafNode"));
            }
            return leafElement;
        }
        LeafElement leaf = ASTFactory.DefaultFactoryHolder.DEFAULT.createLeaf(this.myDelegate, leafText);
        assert (leaf != null);
        LeafElement leafElement = leaf;
        if (leafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/psi/HamlWrapperTokenType", "createLeafNode"));
        }
        return leafElement;
    }
}

