/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.heroku.cloud;

import com.intellij.javaee.heroku.agent.cloud.HerokuCloudAgent;
import com.intellij.javaee.heroku.agent.cloud.HerokuCloudAgentConfig;
import com.intellij.javaee.heroku.cloud.HerokuApplicationRuntime;
import com.intellij.javaee.heroku.cloud.HerokuCloudConfiguration;
import com.intellij.javaee.heroku.cloud.HerokuCloudType;
import com.intellij.javaee.heroku.cloud.HerokuDeploymentConfiguration;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.agent.util.CloudAgentConfigBase;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.remoteServer.util.ssh.SshKeyAwareServerRuntime;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HerokuServerRuntimeInstance
extends CloudMultiSourceServerRuntimeInstance<HerokuDeploymentConfiguration, HerokuCloudAgentConfig, HerokuCloudAgent, HerokuCloudConfiguration>
implements SshKeyAwareServerRuntime {
    private static final String SPECIFICS_MODULE_NAME = "HerokuSrv";
    private static final String SPECIFICS_JAR_PATH = "specifics/herokuSpecifics.jar";
    private final RemoteServer<HerokuCloudConfiguration> myServer;

    public HerokuServerRuntimeInstance(RemoteServer<HerokuCloudConfiguration> server, ServerTaskExecutor taskExecutor, List<File> clientLibrary) throws Exception {
        super((ServerType)HerokuCloudType.getInstance(), (CloudAgentConfigBase)server.getConfiguration(), taskExecutor, clientLibrary, Collections.emptyList(), SPECIFICS_MODULE_NAME, SPECIFICS_JAR_PATH, HerokuCloudAgent.class, "com.intellij.javaee.heroku.agent.cloud.HerokuCloudAgentImpl");
        this.myServer = server;
    }

    @NotNull
    public String getDeploymentName(@NotNull DeploymentSource source, HerokuDeploymentConfiguration configuration) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javaee/heroku/cloud/HerokuServerRuntimeInstance", "getDeploymentName"));
        }
        String string = configuration.getDeploymentSourceName(source);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/heroku/cloud/HerokuServerRuntimeInstance", "getDeploymentName"));
        }
        return string;
    }

    @NotNull
    public String getDeploymentName(@NotNull DeploymentSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javaee/heroku/cloud/HerokuServerRuntimeInstance", "getDeploymentName"));
        }
        throw new UnsupportedOperationException();
    }

    protected void doConnect(HerokuCloudConfiguration configuration, CloudAgentLogger logger) {
        ((HerokuCloudAgent)this.getAgent()).connect(configuration, (CloudAgentErrorHandler)this.getAgentTaskExecutor(), logger);
    }

    public void addSshKey(File sshKey) throws ServerRuntimeException {
        String sshKeyText;
        try {
            sshKeyText = FileUtil.loadFile((File)sshKey);
        }
        catch (IOException e) {
            throw new ServerRuntimeException((Throwable)e);
        }
        this.addSshKey(sshKeyText);
    }

    public void addSshKey(String sshKey) throws ServerRuntimeException {
        this.getAgentTaskExecutor().execute(() -> {
            ((HerokuCloudAgent)this.getAgent()).addSshKey(sshKey);
            return null;
        });
    }

    public CloudServerRuntimeInstance asCloudServerRuntime() {
        return this;
    }

    public RemoteServer getServer() {
        return this.myServer;
    }

    protected CloudApplicationRuntime createApplicationRuntime(CloudRemoteApplication application) {
        return new HerokuApplicationRuntime(this, application.getName());
    }
}

