/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.heroku.cloud;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.heroku.cloud.HerokuCloudConfiguration;
import com.intellij.javaee.heroku.cloud.HerokuDeploymentDetector;
import com.intellij.javaee.heroku.cloud.HerokuServerRuntimeInstance;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentNameProvider;
import com.intellij.remoteServer.util.CloudGitDeploymentChecker;
import com.intellij.remoteServer.util.CloudGitDeploymentDetector;
import org.jetbrains.annotations.NotNull;

public class HerokuDeploymentConfiguration
extends CloudDeploymentNameConfiguration<HerokuDeploymentConfiguration> {
    public static final CloudDeploymentNameProvider DEPLOYMENT_NAME_PROVIDER = new CloudDeploymentNameProvider(){

        @NotNull
        public String getDeploymentName(@NotNull DeploymentSource deploymentSource) {
            if (deploymentSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentSource", "com/intellij/javaee/heroku/cloud/HerokuDeploymentConfiguration$1", "getDeploymentName"));
            }
            String string = CloudDeploymentNameProvider.DEFAULT_NAME_PROVIDER.getDeploymentName(deploymentSource).replace('_', '-');
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/heroku/cloud/HerokuDeploymentConfiguration$1", "getDeploymentName"));
            }
            return string;
        }
    };
    private static final CloudGitDeploymentChecker<HerokuDeploymentConfiguration, HerokuCloudConfiguration, HerokuServerRuntimeInstance> ourCloudGitDeploymentChecker = new CloudGitDeploymentChecker((CloudGitDeploymentDetector)new HerokuDeploymentDetector());
    private Integer myDebugPort;
    private String myHost;

    public Integer getDebugPort() {
        return this.myDebugPort;
    }

    public void setDebugPort(Integer debugPort) {
        this.myDebugPort = debugPort;
    }

    public String getHost() {
        return this.myHost;
    }

    public void setHost(String host) {
        this.myHost = host;
    }

    protected String getDefaultDeploymentSourceName(DeploymentSource deploymentSource) {
        return DEPLOYMENT_NAME_PROVIDER.getDeploymentName(deploymentSource);
    }

    public void checkConfiguration(RemoteServer<?> server, DeploymentSource deploymentSource) throws RuntimeConfigurationException {
        ourCloudGitDeploymentChecker.checkGitUrl(server, deploymentSource, (CloudDeploymentNameConfiguration)this);
    }
}

