/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module.settings.doja;

import com.intellij.j2meplugin.module.J2MEModuleBuilder;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.j2meplugin.module.settings.MobileSettingsConfigurable;
import com.intellij.j2meplugin.module.settings.doja.DOJASettings;
import com.intellij.j2meplugin.module.settings.doja.DOJASettingsConfigurable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;

public class DOJAApplicationType
extends MobileApplicationType {
    @NonNls
    public static final String APPLICATION_NAME = "AppName";
    @NonNls
    public static final String PACKAGE_URL = "PackageUrl";
    @NonNls
    public static final String APPLICATION_SIZE = "AppSize";
    @NonNls
    public static final String APPLICATION_CLASS = "AppClass";
    @NonNls
    public static final String LAST_MODIFIED = "LastModified";
    @NonNls
    public static final String APP_VER = "AppVersion";
    @NonNls
    public static final String CONFIGURATION_VER = "ConfigurationVer";
    @NonNls
    public static final String PROFILE_VER = "ProfileVer";
    @NonNls
    public static final String SP_SIZE = "SPsize";
    @NonNls
    public static final String APP_PARAMS = "AppParam";
    @NonNls
    public static final String USE_NETWORK = "UseNetwork";
    @NonNls
    public static final String TARGET_DEVICE = "TargetDevice";
    @NonNls
    public static final String LAUNCH_AT = "LaunchAt";
    @NonNls
    public static final String APP_TRACE = "AppTrace";
    @NonNls
    public static final String DRAW_AREA = "DrawArea";
    @NonNls
    public static final String GET_UTN = "GetUtn";
    @NonNls
    public static final String NAME = "DoJa";
    public static final String[] ADDITIONAL_SETTINGS = new String[]{"AppVersion", "ConfigurationVer", "ProfileVer", "SPsize", "AppParam", "UseNetwork", "TargetDevice", "LaunchAt", "AppTrace", "DrawArea", "GetUtn"};
    private final ArrayList<String> ourFields = new ArrayList();

    public DOJAApplicationType() {
        this.ourFields.add(APPLICATION_NAME);
        this.ourFields.add(PACKAGE_URL);
        this.ourFields.add(APPLICATION_SIZE);
        this.ourFields.add(APPLICATION_CLASS);
        this.ourFields.add(LAST_MODIFIED);
        for (String setting : ADDITIONAL_SETTINGS) {
            this.ourFields.add(setting);
        }
    }

    public static DOJAApplicationType getInstance() {
        MobileApplicationType[] applicationTypes;
        for (MobileApplicationType applicationType : applicationTypes = (MobileApplicationType[])ApplicationManager.getApplication().getExtensions(MOBILE_APPLICATION_TYPE)) {
            if (!(applicationType instanceof DOJAApplicationType)) continue;
            return (DOJAApplicationType)applicationType;
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getExtension() {
        return "jam";
    }

    @Override
    public String getSeparator() {
        return "=";
    }

    @Override
    public String getJarSizeSettingName() {
        return APPLICATION_SIZE;
    }

    @Override
    public String getBaseClassName() {
        return "com.nttdocomo.ui.IApplication";
    }

    @Override
    public String getJarUrlSettingName() {
        return PACKAGE_URL;
    }

    @Override
    public boolean isUserField(String name) {
        return !this.ourFields.contains(name);
    }

    @Override
    public String createConfigurationByClass(String className) {
        return "AppClass=" + className;
    }

    @Override
    public Class<? extends MobileModuleSettings> getClassType() {
        return DOJASettings.class;
    }

    @Override
    public MobileSettingsConfigurable createConfigurable(Project project, Module module, MobileModuleSettings settings) {
        return new DOJASettingsConfigurable(module, settings, project);
    }

    @Override
    public MobileModuleSettings createTempSettings(J2MEModuleBuilder builder) {
        DOJASettings settings = new DOJASettings();
        settings.initSettings(builder);
        return settings;
    }
}

