/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module.settings;

import com.intellij.j2meplugin.compiler.MobileMakeUtil;
import com.intellij.j2meplugin.emulator.MobileSdk;
import com.intellij.j2meplugin.module.J2MEModuleBuilder;
import com.intellij.j2meplugin.module.J2MEModuleProperties;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.j2meplugin.module.settings.general.UserDefinedOption;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class MobileModuleSettings
implements JDOMExternalizable {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2meplugin");
    protected HashSet<UserDefinedOption> userDefinedOptions = new HashSet();
    protected TreeMap<String, String> properties = new TreeMap();
    protected String myMobileDescriptionPath = "";
    protected String myJarURL = "";
    protected Module myModule;
    protected boolean mySynchronized = false;
    protected boolean myUseUserManifest = false;
    protected String myUserManifestPath;
    @NonNls
    protected static final String DESCRIPTION_PATH = "descriptionPath";
    @NonNls
    protected static final String DESCRIPTION_PATH_VALUE = "path";
    @NonNls
    protected static final String SETTING = "setting";
    @NonNls
    protected static final String SETTING_NAME = "name";
    @NonNls
    protected static final String SETTING_VALUE = "module.settings.user.defined.value";
    @NonNls
    protected static final String USER_DEFINED_OPTIONS = "userDefinedOptions";
    @NonNls
    protected static final String USER_OPTION = "option";
    @NonNls
    protected static final String USER_OPTION_KEY = "module.settings.user.defined.key";
    @NonNls
    protected static final String USER_OPTION_VALUE = "module.settings.user.defined.value";
    private boolean isModified = false;
    @NonNls
    private static final String USE_USER_DESCRIPTOR = "useUserDescriptor";
    @NonNls
    private static final String USE_USER_MANIFEST = "useUserManifest";
    @NonNls
    private static final String MANIFEST = "manifest";
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String JAR_URL_NAME = "jarUrlName";
    @NonNls
    private static final String JAR_URL_SETTING = "jarUrl";
    protected boolean myDefaultModified = false;
    @NonNls
    private static final String JAR_FILE_TYPE = ".jar";

    public boolean isDefaultModified() {
        return this.myDefaultModified;
    }

    public void setDefaultModified(boolean defaultModified) {
        this.myDefaultModified = defaultModified;
    }

    protected MobileModuleSettings() {
    }

    public MobileModuleSettings(Module module) {
        this.myModule = module;
    }

    @Nullable
    public static MobileModuleSettings getInstance(Module module) {
        J2MEModuleProperties properties = J2MEModuleProperties.getInstance(module);
        if (properties == null) {
            return null;
        }
        MobileApplicationType applicationType = properties.getMobileApplicationType();
        if (applicationType == null) {
            return null;
        }
        return (MobileModuleSettings)ModuleServiceManager.getService((Module)module, applicationType.getClassType());
    }

    public TreeMap<String, String> getSettings() {
        return this.properties;
    }

    private void setSettings(TreeMap<String, String> properties) {
        this.properties = properties;
    }

    public HashSet<UserDefinedOption> getUserDefinedOptions() {
        return this.userDefinedOptions;
    }

    public void addUserDefinedOption(UserDefinedOption userDefinedOption) {
        this.userDefinedOptions.add(userDefinedOption);
    }

    protected void setUserDefinedOptions(HashSet<UserDefinedOption> userDefinedOptions) {
        this.userDefinedOptions = userDefinedOptions;
    }

    public Module getModule() {
        return this.myModule;
    }

    public boolean isSynchronized() {
        return this.mySynchronized;
    }

    public void setSynchronized(boolean aSynchronized) {
        this.mySynchronized = aSynchronized;
    }

    public boolean isUseUserManifest() {
        return this.myUseUserManifest;
    }

    public void setUseUserManifest(boolean useUserManifest) {
        this.myUseUserManifest = useUserManifest;
    }

    public String getUserManifestPath() {
        return this.myUserManifestPath;
    }

    public void setUserManifestPath(String userManifestPath) {
        this.myUserManifestPath = userManifestPath;
    }

    public String getJarURL() {
        return this.myJarURL;
    }

    public void setJarURL(String jarURL) {
        this.myJarURL = jarURL;
    }

    public void copyTo(MobileModuleSettings mobileModuleSettings) {
        mobileModuleSettings.setSettings(this.properties);
        mobileModuleSettings.setMobileDescriptionPath(this.getMobileDescriptionPath());
        mobileModuleSettings.setUserDefinedOptions(this.userDefinedOptions);
        mobileModuleSettings.setJarURL(this.myJarURL);
        mobileModuleSettings.setSynchronized(this.mySynchronized);
        mobileModuleSettings.setUserManifestPath(this.myUserManifestPath);
        mobileModuleSettings.setUseUserManifest(this.myUseUserManifest);
    }

    public String getMobileDescriptionPath() {
        return this.myMobileDescriptionPath;
    }

    public void setMobileDescriptionPath(String mobileDescriptionPath) {
        this.myMobileDescriptionPath = mobileDescriptionPath;
    }

    public boolean putSetting(String key, String value) {
        if (value != null && value.length() != 0 && key != null) {
            this.properties.put(key, value);
            return true;
        }
        return false;
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        this.readSetting(parentElement);
    }

    public void readSetting(Element parentElement) {
        Element userOptionsGroup;
        Element jarUrl;
        Element manifest;
        for (Element setting : parentElement.getChildren(SETTING)) {
            this.putSetting(setting.getAttributeValue(SETTING_NAME), setting.getAttributeValue("module.settings.user.defined.value"));
        }
        Element path = parentElement.getChild(DESCRIPTION_PATH);
        if (path != null) {
            String useUserDescriptor;
            String descriptorPath = path.getAttributeValue("path");
            if (descriptorPath != null) {
                this.myMobileDescriptionPath = descriptorPath.replace('/', File.separatorChar);
            }
            if ((useUserDescriptor = path.getAttributeValue(USE_USER_DESCRIPTOR)) != null) {
                this.mySynchronized = useUserDescriptor.equals(Boolean.TRUE.toString());
            }
        }
        if ((manifest = parentElement.getChild(MANIFEST)) != null) {
            this.myUseUserManifest = manifest.getAttributeValue(USE_USER_MANIFEST).equals(Boolean.TRUE.toString());
            String manifestPath = manifest.getAttributeValue("path");
            if (manifestPath != null) {
                this.myUserManifestPath = manifestPath.replace('/', File.separatorChar);
            }
        }
        if ((jarUrl = parentElement.getChild(JAR_URL_SETTING)) != null && jarUrl.getAttributeValue(JAR_URL_NAME) != null) {
            this.myJarURL = jarUrl.getAttributeValue(JAR_URL_NAME).replace('/', File.separatorChar);
        }
        if ((userOptionsGroup = parentElement.getChild(USER_DEFINED_OPTIONS)) != null) {
            for (Element option : userOptionsGroup.getChildren(USER_OPTION)) {
                UserDefinedOption userDefinedOption = new UserDefinedOption(option.getAttributeValue(USER_OPTION_KEY), option.getAttributeValue("module.settings.user.defined.value"));
                this.userDefinedOptions.add(userDefinedOption);
            }
        }
    }

    public void writeExternal(Element parentElement) throws WriteExternalException {
        this.writeSetting(parentElement);
    }

    public void writeSetting(Element parentElement) {
        for (String key : this.properties.keySet()) {
            Element setting = new Element(SETTING);
            setting.setAttribute(SETTING_NAME, key);
            setting.setAttribute("module.settings.user.defined.value", this.properties.get(key));
            parentElement.addContent(setting);
        }
        if (this.myJarURL != null) {
            Element jarUrl = new Element(JAR_URL_SETTING);
            jarUrl.setAttribute(JAR_URL_NAME, this.myJarURL.replace(File.separatorChar, '/'));
            parentElement.addContent(jarUrl);
        }
        if (this.myMobileDescriptionPath != null && !this.myMobileDescriptionPath.equals("")) {
            Element description = new Element(DESCRIPTION_PATH);
            description.setAttribute("path", this.myMobileDescriptionPath.replace(File.separatorChar, '/'));
            description.setAttribute(USE_USER_DESCRIPTOR, Boolean.toString(this.mySynchronized));
            parentElement.addContent(description);
        }
        Element manifest = new Element(MANIFEST);
        manifest.setAttribute(USE_USER_MANIFEST, Boolean.toString(this.myUseUserManifest));
        if (this.myUserManifestPath != null) {
            manifest.setAttribute("path", this.myUserManifestPath.replace(File.separatorChar, '/'));
        }
        parentElement.addContent(manifest);
        if (!this.userDefinedOptions.isEmpty()) {
            Element userOptionsGroup = new Element(USER_DEFINED_OPTIONS);
            Iterator<UserDefinedOption> iterator = this.userDefinedOptions.iterator();
            while (iterator.hasNext()) {
                Element userOption = new Element(USER_OPTION);
                UserDefinedOption option = iterator.next();
                userOption.setAttribute(USER_OPTION_KEY, option.getKey());
                userOption.setAttribute("module.settings.user.defined.value", option.getValue());
                userOptionsGroup.addContent(userOption);
            }
            parentElement.addContent(userOptionsGroup);
        }
    }

    protected void putIfNotExists(String key, String value) {
        if (value != null && key != null) {
            if (this.properties.containsKey(key) && (this.properties.get(key) == null || this.properties.get(key).length() == 0)) {
                this.properties.put(key, value);
            } else if (!this.properties.containsKey(key)) {
                this.properties.put(key, value);
            }
        }
    }

    public void initSettings(J2MEModuleBuilder moduleBuilder) {
        if (moduleBuilder.getModuleFileDirectory() != null) {
            if (!this.myDefaultModified || this.myJarURL == null || this.myJarURL.length() == 0) {
                this.myJarURL = FileUtil.toSystemDependentName((String)moduleBuilder.getModuleFileDirectory()) + File.separator + moduleBuilder.getName() + JAR_FILE_TYPE;
            }
            if (!this.myDefaultModified || this.myMobileDescriptionPath == null || this.myMobileDescriptionPath.length() == 0) {
                this.myMobileDescriptionPath = FileUtil.toSystemDependentName((String)moduleBuilder.getModuleFileDirectory()) + File.separator + moduleBuilder.getName() + "." + moduleBuilder.getMobileApplicationType().getExtension();
            }
            if (!this.myDefaultModified) {
                this.putSetting(moduleBuilder.getMobileApplicationType().getJarUrlSettingName(), moduleBuilder.getName() + JAR_FILE_TYPE);
            } else {
                this.putIfNotExists(moduleBuilder.getMobileApplicationType().getJarUrlSettingName(), moduleBuilder.getName() + JAR_FILE_TYPE);
            }
            this.isModified = true;
        }
    }

    public void prepareJarSettings() {
        if (!MobileSdk.checkCorrectness(ModuleRootManager.getInstance((Module)this.myModule).getSdk(), this.myModule)) {
            return;
        }
        MobileApplicationType mobileApplicationType = J2MEModuleProperties.getInstance(this.myModule).getMobileApplicationType();
        if (this.myJarURL != null) {
            this.properties.put(mobileApplicationType.getJarSizeSettingName(), new Long(new File(this.myJarURL).length()).toString());
        }
    }

    @Nullable
    public File getManifest() {
        if (this.myUseUserManifest && this.myUserManifestPath != null) {
            return new File(this.myUserManifestPath);
        }
        return null;
    }

    protected static void putManifestAttribute(PrintWriter pw, String key, String separator, String value) {
        if (value != null && value.length() != 0) {
            pw.println(key + separator + " " + value);
        }
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean modified) {
        this.isModified = modified;
    }

    public SortedSet<String> getMIDlets() {
        return new TreeSet<String>();
    }

    public abstract void setMIDletClassName(String var1, String var2);

    @Nullable
    public abstract String getMIDletClassName(String var1);

    public abstract boolean isMidletKey(String var1);

    public abstract MobileApplicationType getApplicationType();

    public void addMidlet(String qualifiedName) {
        if (this.isSynchronized()) {
            try {
                MobileMakeUtil.makeJad(this, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public abstract boolean containsMidlet(String var1);
}

