/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.module.MobileModuleUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditModuleSettingsIntentionAction
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(EditModuleSettingsIntentionAction.class);

    @NotNull
    public String getText() {
        String string = J2MEBundle.message("edit.mobile.module.settings.intention.title", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/module/intentions/EditModuleSettingsIntentionAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/module/intentions/EditModuleSettingsIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/j2meplugin/module/intentions/EditModuleSettingsIntentionAction", "isAvailable"));
        }
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        Module module = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            return false;
        }
        return MobileModuleUtil.isExecutable(EditModuleSettingsIntentionAction.findClassUnderCursor(editor, file), module);
    }

    @Nullable
    private static PsiClass findClassUnderCursor(Editor editor, PsiFile file) {
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PsiClass.class);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/j2meplugin/module/intentions/EditModuleSettingsIntentionAction", "invoke"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        LOG.assertTrue(virtualFile != null);
        Module module = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        LOG.assertTrue(module != null);
        ProjectSettingsService.getInstance((Project)project).showModuleConfigurationDialog(module.getName(), J2MEBundle.message("mobile.module.settings.title", new Object[0]));
    }

    public boolean startInWriteAction() {
        return false;
    }
}

