/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module;

import com.intellij.j2meplugin.module.J2MEModuleProperties;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobileModuleUtil {
    private MobileModuleUtil() {
    }

    public static MobileApplicationType[] getExistingMobileApplicationTypes() {
        return (MobileApplicationType[])ApplicationManager.getApplication().getExtensions(MobileApplicationType.MOBILE_APPLICATION_TYPE);
    }

    @Nullable
    public static MobileApplicationType getMobileApplicationTypeByName(String name) {
        for (MobileApplicationType applicationType : MobileModuleUtil.getExistingMobileApplicationTypes()) {
            if (!Comparing.strEqual((String)name, (String)applicationType.getName())) continue;
            return applicationType;
        }
        return null;
    }

    public static boolean isExecutable(@Nullable PsiClass psiClass, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/j2meplugin/module/MobileModuleUtil", "isExecutable"));
        }
        if (psiClass != null) {
            J2MEModuleProperties moduleProperties;
            if (psiClass.getNameIdentifier() == null) {
                return false;
            }
            if (module == ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass) && (moduleProperties = J2MEModuleProperties.getInstance(module)) != null) {
                Project project = module.getProject();
                MobileApplicationType applicationType = moduleProperties.getMobileApplicationType();
                if (applicationType != null) {
                    String fqName = applicationType.getBaseClassName();
                    PsiClass baseClass = JavaPsiFacade.getInstance((Project)project).findClass(fqName, GlobalSearchScope.allScope((Project)project));
                    if (baseClass != null && psiClass.isInheritor(baseClass, true)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

