/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.module.J2MEModuleBuilder;
import com.intellij.j2meplugin.module.settings.ui.J2MEModuleTypeStep;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.util.ArrayUtil;
import icons.J2mepluginIcons;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class J2MEModuleType
extends ModuleType<J2MEModuleBuilder> {
    @NonNls
    public static final String ID = "J2ME_MODULE";

    public J2MEModuleType() {
        super(ID);
    }

    public static J2MEModuleType getInstance() {
        return (J2MEModuleType)ModuleTypeManager.getInstance().findByID(ID);
    }

    @NotNull
    public J2MEModuleBuilder createModuleBuilder() {
        J2MEModuleBuilder j2MEModuleBuilder = new J2MEModuleBuilder();
        if (j2MEModuleBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/module/J2MEModuleType", "createModuleBuilder"));
        }
        return j2MEModuleBuilder;
    }

    @NotNull
    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull J2MEModuleBuilder moduleBuilder, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardContext", "com/intellij/j2meplugin/module/J2MEModuleType", "createWizardSteps"));
        }
        if (moduleBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleBuilder", "com/intellij/j2meplugin/module/J2MEModuleType", "createWizardSteps"));
        }
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/j2meplugin/module/J2MEModuleType", "createWizardSteps"));
        }
        ArrayList<J2MEModuleTypeStep> steps = new ArrayList<J2MEModuleTypeStep>();
        steps.add(new J2MEModuleTypeStep(moduleBuilder, null, "j2me.support.creating.mobile.module"));
        Object[] wizardSteps = steps.toArray(new ModuleWizardStep[steps.size()]);
        ModuleWizardStep[] moduleWizardStepArray = (ModuleWizardStep[])ArrayUtil.mergeArrays((Object[])wizardSteps, (Object[])super.createWizardSteps(wizardContext, (ModuleBuilder)moduleBuilder, modulesProvider));
        if (moduleWizardStepArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/module/J2MEModuleType", "createWizardSteps"));
        }
        return moduleWizardStepArray;
    }

    @NotNull
    public String getName() {
        String string = J2MEBundle.message("module.type.title", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/module/J2MEModuleType", "getName"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = J2MEBundle.message("module.type.description", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/module/J2MEModuleType", "getDescription"));
        }
        return string;
    }

    public Icon getBigIcon() {
        return J2mepluginIcons.Mobile;
    }

    public Icon getNodeIcon(boolean isOpened) {
        return J2mepluginIcons.Small_mobile;
    }

    public boolean isValidSdk(@NotNull Module module, Sdk projectSdk) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/j2meplugin/module/J2MEModuleType", "isValidSdk"));
        }
        return JavaModuleType.isValidJavaSdk((Module)module);
    }
}

