/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.emulator.ui;

import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.emulator.Emulator;
import com.intellij.j2meplugin.emulator.midp.MIDPEmulatorType;
import com.intellij.j2meplugin.emulator.ui.MobileApiSettingsEditor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class MobileDefaultApiEditor
extends MobileApiSettingsEditor {
    private JTextField myProfile;
    private JTextField myConfiguration;
    private JPanel myMIDPPanel;
    private JRadioButton myDefaultConfigs;
    private JLabel myDefaultProfile;
    private JLabel myDefaultConfig;
    private JRadioButton myCustomConfigs;
    private static final Logger LOG = Logger.getInstance((String)("#" + MobileDefaultApiEditor.class.getName()));

    public MobileDefaultApiEditor() {
        this.$$$setupUI$$$();
    }

    @Override
    @NotNull
    public JComponent createEditor() {
        ButtonGroup useConfigs = new ButtonGroup();
        useConfigs.add(this.myDefaultConfigs);
        useConfigs.add(this.myCustomConfigs);
        this.myDefaultConfigs.setSelected(true);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MobileDefaultApiEditor.this.myModified = true;
            }
        };
        this.myDefaultConfigs.addActionListener(listener);
        this.myCustomConfigs.addActionListener(listener);
        this.myProfile.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                MobileDefaultApiEditor.this.myModified = true;
            }
        });
        this.myConfiguration.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                MobileDefaultApiEditor.this.myModified = true;
            }
        });
        JPanel jPanel = this.myMIDPPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/emulator/ui/MobileDefaultApiEditor", "createEditor"));
        }
        return jPanel;
    }

    @Override
    public void resetEditorFrom(Emulator emulator) {
        MIDPEmulatorType emulatorType = (MIDPEmulatorType)emulator.getEmulatorType();
        LOG.assertTrue(emulatorType != null);
        String defaultProfile = emulatorType.getDefaultProfile(emulator.getHome());
        String defaultConfiguration = emulatorType.getDefaultConfiguration(emulator.getHome());
        this.myDefaultProfile.setText(defaultProfile);
        this.myDefaultConfig.setText(defaultConfiguration);
        if (Comparing.equal((String)defaultProfile, (String)emulator.getProfile()) && Comparing.equal((String)defaultConfiguration, (String)emulator.getConfiguration()) || emulator.getProfile() == null || emulator.getConfiguration() == null) {
            this.myDefaultConfigs.setSelected(true);
        } else {
            this.myCustomConfigs.setSelected(true);
        }
        if (emulator.getCustomProfile() == null || emulator.getCustomProfile().length() == 0) {
            this.myProfile.setText(defaultProfile);
        } else {
            this.myProfile.setText(emulator.getCustomProfile());
        }
        if (emulator.getCustomConfiguration() == null || emulator.getCustomConfiguration().length() == 0) {
            this.myConfiguration.setText(defaultConfiguration);
        } else {
            this.myConfiguration.setText(emulator.getCustomConfiguration());
        }
        this.myModified = false;
    }

    @Override
    public void applyEditorTo(Emulator emulator) throws ConfigurationException {
        if (this.myCustomConfigs.isSelected()) {
            if (this.myProfile.getText() == null || this.myProfile.getText().length() == 0) {
                throw new ConfigurationException(J2MEBundle.message("emulator.profile.version.misconfigured", new Object[0]));
            }
            emulator.setProfile(this.myProfile.getText());
            if (this.myConfiguration.getText() == null || this.myConfiguration.getText().length() == 0) {
                throw new ConfigurationException(J2MEBundle.message("emulator.configuration.version.misconfigured", new Object[0]));
            }
            emulator.setConfiguration(this.myConfiguration.getText());
        } else {
            emulator.setProfile(this.myDefaultProfile.getText());
            emulator.setConfiguration(this.myDefaultConfig.getText());
        }
        emulator.setCustomProfile(this.myProfile.getText());
        emulator.setCustomConfiguration(this.myConfiguration.getText());
        this.myModified = false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.myMIDPPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(2, 0, 2, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("emulator.profile.version"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("emulator.configuration.version"));
        jPanel.add((Component)jLabel4, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProfile = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(2, 2, 1, 1, 8, 1, 0, 0, null, new Dimension(75, -1), null));
        this.myConfiguration = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(3, 2, 1, 1, 8, 1, 0, 0, null, new Dimension(75, -1), null));
        this.myCustomConfigs = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("emulator.custom.profile.configuration.versions"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(2, 0, 2, 1, 8, 0, 3, 0, null, null, null));
        this.myDefaultConfigs = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("emulator.default.profile.configuration.versions"));
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 0, 2, 1, 8, 0, 3, 0, null, null, null));
        this.myDefaultProfile = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDefaultConfig = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("emulator.profile.version"));
        jPanel.add((Component)jLabel5, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("emulator.configuration.version"));
        jPanel.add((Component)jLabel6, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 3, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMIDPPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

