/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.emulator;

import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.emulator.EmulatorType;
import com.intellij.j2meplugin.emulator.EmulatorUtil;
import com.intellij.j2meplugin.emulator.midp.MIDPEmulatorType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.ValidatableSdkAdditionalData;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class Emulator
implements ValidatableSdkAdditionalData,
JDOMExternalizable {
    @NonNls
    public static final String COMMANDS = "commands";
    @NonNls
    public static final String COMMAND = "command";
    @NonNls
    public static final String NAME = "name";
    private String[] myOTACommands;
    private EmulatorType myEmulatorType;
    private String myJavaSdkName;
    private String myHome;
    private String[] myPreverifyOptions;
    private String myProfile;
    private String myConfiguration;
    private String myCustomProfile;
    private String myCustomConfiguration;
    @NonNls
    private static final String JDK = "javaJDK";
    @NonNls
    private static final String JDK_NAME = "name";
    @NonNls
    private static final String EMULATOR_TYPE = "emulator";
    @NonNls
    private static final String EMULATOR_NAME = "name";
    @NonNls
    private static final String PROFILE = "profile";
    @NonNls
    private static final String CONFIGURATION = "configuration";
    @NonNls
    private static final String CUSTOM_PROFILE = "customProfile";
    @NonNls
    private static final String CUSTOM_CONFIGURATION = "customConfiguration";
    @NonNls
    private static final String PREVERIFY_OPTIONS = "preverify";
    @NonNls
    private static final String OPTION = "option";
    @NonNls
    private static final String OPTION_NAME = "name";
    private static final Logger LOG = Logger.getInstance((String)("#" + Emulator.class.getName()));

    public Emulator(EmulatorType emulatorType, String[] preverifyOptions, String javaSdk, String home) {
        this.myEmulatorType = emulatorType;
        this.myPreverifyOptions = preverifyOptions;
        this.myJavaSdkName = javaSdk;
        this.myHome = home;
    }

    public Emulator() {
    }

    public Object clone() throws CloneNotSupportedException {
        Emulator clone = new Emulator(this.myEmulatorType, this.myPreverifyOptions, this.myJavaSdkName, this.myHome);
        return clone;
    }

    public void checkValid(SdkModel sdkModel) throws ConfigurationException {
        if (this.getJavaSdk(sdkModel) == null) {
            throw new ConfigurationException(J2MEBundle.message("jdk.already.removed", this.myJavaSdkName));
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element emulatorType;
        Element jdk = element.getChild(JDK);
        if (jdk != null) {
            this.myJavaSdkName = jdk.getAttributeValue("name");
        }
        if ((emulatorType = element.getChild(EMULATOR_TYPE)) != null) {
            this.myEmulatorType = EmulatorUtil.getEmulatorTypeByName(emulatorType.getAttributeValue("name"));
            this.myProfile = emulatorType.getAttributeValue(PROFILE);
            this.myConfiguration = emulatorType.getAttributeValue(CONFIGURATION);
            this.myCustomProfile = emulatorType.getAttributeValue(CUSTOM_PROFILE);
            this.myCustomConfiguration = emulatorType.getAttributeValue(CUSTOM_CONFIGURATION);
        }
        ArrayList<String> options = new ArrayList<String>();
        Element preverifyOptions = element.getChild(PREVERIFY_OPTIONS);
        if (preverifyOptions != null) {
            Iterator iterator = preverifyOptions.getChildren(OPTION).iterator();
            while (iterator.hasNext()) {
                options.add(((Element)iterator.next()).getAttributeValue("name"));
            }
            this.myPreverifyOptions = ArrayUtil.toStringArray(options);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (this.myJavaSdkName != null) {
            Element jdk = new Element(JDK);
            jdk.setAttribute("name", this.myJavaSdkName);
            element.addContent(jdk);
        }
        Element emulatorType = new Element(EMULATOR_TYPE);
        if (this.myEmulatorType != null) {
            String configuration;
            emulatorType.setAttribute("name", this.myEmulatorType.getName());
            String profile = this.getProfile();
            if (profile != null) {
                emulatorType.setAttribute(PROFILE, profile);
            }
            if ((configuration = this.getConfiguration()) != null) {
                emulatorType.setAttribute(CONFIGURATION, configuration);
            }
            if (this.myCustomProfile != null) {
                emulatorType.setAttribute(CUSTOM_PROFILE, this.myCustomProfile);
            }
            if (this.myCustomConfiguration != null) {
                emulatorType.setAttribute(CUSTOM_CONFIGURATION, this.myCustomConfiguration);
            }
        }
        element.addContent(emulatorType);
        Element options = new Element(PREVERIFY_OPTIONS);
        for (int i = 0; this.myPreverifyOptions != null && i < this.myPreverifyOptions.length; ++i) {
            Element option = new Element(OPTION);
            option.setAttribute("name", this.myPreverifyOptions[i]);
            options.addContent(option);
        }
        element.addContent(options);
    }

    @Nullable
    public String[] getOTACommands(String home) {
        if (this.myOTACommands == null && this.myEmulatorType != null) {
            String[] otaCommands = this.myEmulatorType.getOTACommands(home);
            this.myOTACommands = otaCommands != null ? otaCommands : ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return this.myOTACommands;
    }

    @Nullable
    public String getProfile() {
        if (this.myProfile == null && this.myEmulatorType instanceof MIDPEmulatorType) {
            LOG.assertTrue(this.myHome != null);
            this.myProfile = ((MIDPEmulatorType)this.myEmulatorType).getDefaultProfile(this.myHome);
        }
        return this.myProfile;
    }

    @Nullable
    public String getConfiguration() {
        if (this.myConfiguration == null && this.myEmulatorType instanceof MIDPEmulatorType) {
            LOG.assertTrue(this.myHome != null);
            this.myConfiguration = ((MIDPEmulatorType)this.myEmulatorType).getDefaultConfiguration(this.myHome);
        }
        return this.myConfiguration;
    }

    public void setProfile(String profile) {
        this.myProfile = profile;
    }

    public void setConfiguration(String configuration) {
        this.myConfiguration = configuration;
    }

    public String[] getPreverifyOptions() {
        return this.myPreverifyOptions;
    }

    public String getCustomProfile() {
        return this.myCustomProfile;
    }

    public void setCustomProfile(String customProfile) {
        this.myCustomProfile = customProfile;
    }

    public String getCustomConfiguration() {
        return this.myCustomConfiguration;
    }

    public void setCustomConfiguration(String customConfiguration) {
        this.myCustomConfiguration = customConfiguration;
    }

    public String getHome() {
        return this.myHome;
    }

    public void setHome(String home) {
        this.myHome = home;
    }

    public void setPreverifyOptions(String[] preverifyOptions) {
        this.myPreverifyOptions = preverifyOptions;
    }

    @Nullable
    public EmulatorType getEmulatorType() {
        return this.myEmulatorType;
    }

    public void setEmulatorType(EmulatorType emulatorType) {
        this.myEmulatorType = emulatorType;
    }

    @Nullable
    public Sdk getJavaSdk() {
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        if (this.myJavaSdkName == null) {
            Sdk[] projectJdks;
            for (Sdk jdk : projectJdks = jdkTable.getAllJdks()) {
                if (jdk.getSdkType() != JavaSdk.getInstance()) continue;
                this.myJavaSdkName = jdk.getName();
                break;
            }
        }
        return jdkTable.findJdk(this.myJavaSdkName);
    }

    @Nullable
    public Sdk getJavaSdk(SdkModel sdkModel) {
        return sdkModel.findSdk(this.myJavaSdkName);
    }

    public String getJavaSdkName() {
        return this.myJavaSdkName;
    }

    public void setJavaSdk(String javaSdk) {
        this.myJavaSdkName = javaSdk;
    }
}

