/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.psi.css.descriptor.CssElementDescriptor;
import gnu.trove.THashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPropertyInfo {
    public static final CssPropertyInfo[] EMPTY_ARRAY = new CssPropertyInfo[0];
    @NonNls
    public static final String INITIAL_VALUE_ATTRIBUTE = "initialValue";
    @NonNls
    public static final String APPLIES_TO_ATTRIBUTE = "appliesTo";
    @NonNls
    public static final String INHERITED_ATTRIBUTE = "inherited";
    @NonNls
    public static final String PERCENTAGE_ATTRIBUTE = "percentage";
    @NonNls
    public static final String MEDIA_GROUP_ATTRIBUTE = "mediaGroup";
    @NonNls
    public static final String HELP_REF_ATTRIBUTE = "helpRef";
    private final Map<String, String> myAttributeMap;
    private final CssElementDescriptor.CssVersion myVersion;

    public CssPropertyInfo(@NotNull Element e, @NotNull CssElementDescriptor.CssVersion version) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/css/CssPropertyInfo", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/psi/css/CssPropertyInfo", "<init>"));
        }
        this.myAttributeMap = new THashMap();
        this.addAttributes(e, INITIAL_VALUE_ATTRIBUTE, APPLIES_TO_ATTRIBUTE, INHERITED_ATTRIBUTE, PERCENTAGE_ATTRIBUTE, MEDIA_GROUP_ATTRIBUTE, HELP_REF_ATTRIBUTE);
        this.myVersion = version;
    }

    private void addAttributes(@NotNull Element element, String ... names) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/CssPropertyInfo", "addAttributes"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/psi/css/CssPropertyInfo", "addAttributes"));
        }
        for (String name : names) {
            String attributeValue = element.getAttributeValue(name);
            if (attributeValue == null) continue;
            this.myAttributeMap.put(name, attributeValue);
        }
    }

    @Nullable
    public String getAttributeValue(@NotNull String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/psi/css/CssPropertyInfo", "getAttributeValue"));
        }
        return this.myAttributeMap.get(attributeName);
    }

    public String getInherited() {
        return this.myAttributeMap.get(INHERITED_ATTRIBUTE);
    }

    public String getHelpRef() {
        return this.myAttributeMap.get(HELP_REF_ATTRIBUTE);
    }

    @NotNull
    public CssElementDescriptor.CssVersion getVersion() {
        CssElementDescriptor.CssVersion cssVersion = this.myVersion;
        if (cssVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssPropertyInfo", "getVersion"));
        }
        return cssVersion;
    }
}

