/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.utils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.play.language.psi.PlayPsiFile;
import com.intellij.play.language.psi.PlayTag;
import com.intellij.play.references.PlayFakeRenameableReferenceProvider;
import com.intellij.play.utils.PlayPathUtils;
import com.intellij.play.utils.beans.PlayImplicitVariable;
import com.intellij.play.utils.beans.PlayRenameableImplicitVariable;
import com.intellij.play.utils.processors.ControllerMethodsProcessor;
import com.intellij.play.utils.processors.FieldTagImplicitVariablesProcessor;
import com.intellij.play.utils.processors.ImplicitVariablesProcessor;
import com.intellij.play.utils.processors.ListTagImplicitVariablesProcessor;
import com.intellij.play.utils.processors.LocalVariablesProcessor;
import com.intellij.play.utils.processors.PlayDeclarationsProcessor;
import com.intellij.play.utils.processors.RenderArgProcessor;
import com.intellij.play.utils.processors.TopLevelControllerPackagesProcessor;
import com.intellij.play.utils.processors.TopLevelControllersProcessor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayUtils {
    public static final String CONTROLLERS_PKG = "controllers";
    public static PlayDeclarationsProcessor[] myDeclarationsProcessors = new PlayDeclarationsProcessor[]{new ImplicitVariablesProcessor(), new ControllerMethodsProcessor(), new TopLevelControllersProcessor(), new TopLevelControllerPackagesProcessor(), new LocalVariablesProcessor(), new RenderArgProcessor(), new ListTagImplicitVariablesProcessor(), new FieldTagImplicitVariablesProcessor()};

    public static boolean isController(@Nullable PsiClass psiClass) {
        return psiClass != null && InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"play.mvc.Controller");
    }

    public static boolean isPlayInstalled(Project project) {
        return !project.isDefault() && PackageIndex.getInstance((Project)project).getDirectoriesByPackageName("play.mvc", true).length > 0 && PackageIndex.getInstance((Project)project).getDirectoriesByPackageName("play.api.mvc", true).length == 0;
    }

    @Nullable
    public static PsiClass getObjectClass(Project project) {
        return JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Object", GlobalSearchScope.allScope((Project)project));
    }

    @Nullable
    public static PlayTag getContainingPlayTag(PsiElement expressionElement) {
        return (PlayTag)PsiTreeUtil.getParentOfType((PsiElement)expressionElement, PlayTag.class);
    }

    public static boolean processPlayDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement scope) {
        for (PlayDeclarationsProcessor declarationsProcessor : myDeclarationsProcessors) {
            if (declarationsProcessor.processElement(processor, state, scope)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasSecondaryElements(PsiElement psiElement) {
        if (psiElement instanceof PsiClass) {
            return PlayPathUtils.getCorrespondingDirectory((PsiClass)psiElement) != null;
        }
        if (psiElement instanceof PsiMethod) {
            return PlayPathUtils.getCorrespondingView((PsiMethod)psiElement) != null;
        }
        if (psiElement instanceof PlayPsiFile) {
            return PlayPathUtils.getCorrespondingControllerMethods((PsiFile)psiElement).length > 0;
        }
        return false;
    }

    public static LocalSearchScope getPsiClassLocalScope(@NotNull PsiClass controller) {
        if (controller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controller", "com/intellij/play/utils/PlayUtils", "getPsiClassLocalScope"));
        }
        return new LocalSearchScope((PsiElement[])ArrayUtil.append((Object[])controller.getSupers(), (Object)controller));
    }

    public static Map<String, PlayImplicitVariable> getPutMethodInitVariables(@NotNull PsiMethod psiMethod, @NotNull SearchScope searchScope) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/play/utils/PlayUtils", "getPutMethodInitVariables"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/play/utils/PlayUtils", "getPutMethodInitVariables"));
        }
        ConcurrentMap set = ContainerUtil.newConcurrentMap();
        MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)searchScope, (boolean)true).forEach(psiReference -> {
            PsiExpression expression;
            PsiExpression[] expressions;
            if (set == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/play/utils/PlayUtils", "lambda$getPutMethodInitVariables$0"));
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class);
            if (methodCallExpression != null && (expressions = methodCallExpression.getArgumentList().getExpressions()).length == 2 && (expression = expressions[0]) instanceof PsiLiteralExpression) {
                String name = (String)((PsiLiteralExpression)expression).getValue();
                PsiType type = expressions[1].getType();
                if (name != null && type != null) {
                    set.put(name, new PlayRenameableImplicitVariable(name, type, PlayFakeRenameableReferenceProvider.getOrCreateRenamebaleFakeElement((PsiLiteral)((PsiLiteralExpression)expression))));
                }
            }
            return true;
        });
        return set;
    }
}

