/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.play.completion.beans.PlayFastTagDescriptor;
import com.intellij.play.language.psi.PlayPsiFile;
import com.intellij.play.utils.PlayUtils;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Query;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.hash.HashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayPathUtils {
    private static final String VIEWS_PKG = "views";
    private static final String VIEWS_DEFAULT_EXTENSION = "html";

    @Nullable
    public static PsiDirectory getCorrespondingDirectory(@NotNull PsiClass controller) {
        PsiDirectory directory;
        Module module;
        if (controller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controller", "com/intellij/play/utils/PlayPathUtils", "getCorrespondingDirectory"));
        }
        if (PlayUtils.isController(controller) && (module = ModuleUtil.findModuleForPsiElement((PsiElement)controller)) != null && (directory = PlayPathUtils.getViewsDirectory(module)) != null) {
            return directory.findSubdirectory(controller.getName());
        }
        return null;
    }

    @Nullable
    public static PsiClass getCorrespondingController(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/play/utils/PlayPathUtils", "getCorrespondingController"));
        }
        String path = new String();
        for (PsiDirectory psiDirectory = psiFile.getOriginalFile().getContainingDirectory(); psiDirectory != null && !VIEWS_PKG.equals(psiDirectory.getName()); psiDirectory = psiDirectory.getParentDirectory()) {
            if (path.length() > 0) {
                path = path + ".";
            }
            path = psiDirectory.getName() + path;
        }
        return StringUtil.isEmptyOrSpaces((String)path) ? null : JavaPsiFacade.getInstance((Project)psiFile.getProject()).findClass("controllers." + path, psiFile.getResolveScope());
    }

    @Nullable
    public static PsiClass findControllerByName(@NotNull String controller, @NotNull Module module) {
        if (controller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controller", "com/intellij/play/utils/PlayPathUtils", "findControllerByName"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/play/utils/PlayPathUtils", "findControllerByName"));
        }
        return StringUtil.isEmptyOrSpaces((String)controller) ? null : JavaPsiFacade.getInstance((Project)module.getProject()).findClass("controllers." + controller, GlobalSearchScope.moduleWithDependenciesScope((Module)module));
    }

    @Nullable
    public static LocalSearchScope getRoutsFilesScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/play/utils/PlayPathUtils", "getRoutsFilesScope"));
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module != null) {
            Set<PsiFile> files = PlayPathUtils.getRoutesFiles(module);
            return new LocalSearchScope(files.toArray(new PsiElement[files.size()]));
        }
        return null;
    }

    @NotNull
    public static Set<PsiFile> getRoutesFiles(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/play/utils/PlayPathUtils", "getRoutesFiles"));
        }
        HashSet files = new HashSet();
        Set<PsiDirectory> directories = PlayPathUtils.getConfigDirectories(module);
        for (PsiDirectory directory : directories) {
            PsiFile routes = directory.findFile("routes");
            if (routes == null) continue;
            files.add(routes);
        }
        HashSet hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/utils/PlayPathUtils", "getRoutesFiles"));
        }
        return hashSet;
    }

    @NotNull
    public static PsiMethod[] getCorrespondingControllerMethods(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/play/utils/PlayPathUtils", "getCorrespondingControllerMethods"));
        }
        HashSet psiMethods = new HashSet();
        PsiClass controller = PlayPathUtils.getCorrespondingController(psiFile);
        if (controller != null) {
            String templateName = FileUtil.getNameWithoutExtension((String)psiFile.getName());
            for (PsiMethod psiMethod : controller.getAllMethods()) {
                if (!psiMethod.getName().toLowerCase().equals(templateName.toLowerCase())) continue;
                psiMethods.add(psiMethod);
            }
        }
        PsiMethod[] psiMethodArray = psiMethods.toArray(new PsiMethod[psiMethods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/utils/PlayPathUtils", "getCorrespondingControllerMethods"));
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiFile getCorrespondingView(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/play/utils/PlayPathUtils", "getCorrespondingView"));
        }
        String fileName = psiMethod.getName();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        String controllerPkgName = containingClass.getQualifiedName();
        if (controllerPkgName != null && controllerPkgName.startsWith("controllers")) {
            String viewPkgName = controllerPkgName.replaceFirst("controllers", VIEWS_PKG);
            PsiPackage viewPackage = JavaPsiFacade.getInstance((Project)psiMethod.getProject()).findPackage(viewPkgName);
            if (viewPackage != null) {
                for (PsiDirectory psiDirectory : viewPackage.getDirectories()) {
                    for (PsiFile psiFile : psiDirectory.getFiles()) {
                        VirtualFile virtualFile = psiFile.getVirtualFile();
                        if (virtualFile == null || !fileName.toLowerCase().equals(virtualFile.getNameWithoutExtension().toLowerCase()) || !(psiFile instanceof PlayPsiFile)) continue;
                        return psiFile;
                    }
                }
            }
        }
        return null;
    }

    public static Set<PsiDirectory> getConfigDirectories(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/play/utils/PlayPathUtils", "getConfigDirectories"));
        }
        HashSet configs = new HashSet();
        PlayPathUtils.collectConfigDirectories(module, (Set<PsiDirectory>)configs);
        return configs;
    }

    public static void collectConfigDirectories(@NotNull Module module, @NotNull Set<PsiDirectory> configs) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/play/utils/PlayPathUtils", "collectConfigDirectories"));
        }
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/play/utils/PlayPathUtils", "collectConfigDirectories"));
        }
        PlayPathUtils.collectConfigDirectories(module, configs, (Set<Module>)new HashSet());
    }

    public static void collectConfigDirectories(@NotNull Module module, @NotNull Set<PsiDirectory> configs, @NotNull Set<Module> visitedModules) {
        VirtualFile[] roots;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/play/utils/PlayPathUtils", "collectConfigDirectories"));
        }
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/play/utils/PlayPathUtils", "collectConfigDirectories"));
        }
        if (visitedModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedModules", "com/intellij/play/utils/PlayPathUtils", "collectConfigDirectories"));
        }
        if (visitedModules.contains(module)) {
            return;
        }
        visitedModules.add(module);
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile virtualFile : roots = moduleRootManager.getContentRoots()) {
            PsiDirectory directory;
            VirtualFile conf = virtualFile.findChild("conf");
            if (conf == null || !conf.isDirectory() || (directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(conf)) == null) continue;
            configs.add(directory);
        }
        for (VirtualFile virtualFile : moduleRootManager.getDependencies()) {
            PlayPathUtils.collectConfigDirectories((Module)virtualFile, configs, visitedModules);
        }
    }

    @NotNull
    public static Map<String, PsiFile> getCustomTags(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/play/utils/PlayPathUtils", "getCustomTags"));
        }
        HashMap files = new HashMap();
        PlayPathUtils.collectCustomTags(module, (Map<String, PsiFile>)files);
        HashMap hashMap = files;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/utils/PlayPathUtils", "getCustomTags"));
        }
        return hashMap;
    }

    public static Set<PsiDirectory> getCustomTagRoots(@Nullable Module module) {
        if (module == null) {
            return Collections.emptySet();
        }
        return PlayPathUtils.getCustomTagRoots(module, (Set<Module>)new HashSet());
    }

    public static Set<PsiDirectory> getCustomTagRoots(@NotNull Module module, @NotNull Set<Module> processed) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/play/utils/PlayPathUtils", "getCustomTagRoots"));
        }
        if (processed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "com/intellij/play/utils/PlayPathUtils", "getCustomTagRoots"));
        }
        com.intellij.util.containers.hash.HashSet directories = new com.intellij.util.containers.hash.HashSet();
        if (!processed.contains(module)) {
            VirtualFile[] roots;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (VirtualFile virtualFile : roots = moduleRootManager.getSourceRoots()) {
                PsiDirectory directory;
                VirtualFile tagsDir = virtualFile.findFileByRelativePath("views/tags");
                if (tagsDir == null || !tagsDir.isDirectory() || (directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(tagsDir)) == null) continue;
                directories.add(directory);
            }
            processed.add(module);
            for (VirtualFile virtualFile : moduleRootManager.getDependencies()) {
                directories.addAll(PlayPathUtils.getCustomTagRoots((Module)virtualFile, processed));
            }
        }
        return directories;
    }

    public static void collectCustomTags(@NotNull Module module, @NotNull Map<String, PsiFile> files) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/play/utils/PlayPathUtils", "collectCustomTags"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/play/utils/PlayPathUtils", "collectCustomTags"));
        }
        PlayPathUtils.collectCustomTags(module, files, (Set<Module>)new com.intellij.util.containers.hash.HashSet());
    }

    public static void collectCustomTags(@NotNull Module module, @NotNull Map<String, PsiFile> files, @NotNull Set<Module> processed) {
        VirtualFile[] roots;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/play/utils/PlayPathUtils", "collectCustomTags"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/play/utils/PlayPathUtils", "collectCustomTags"));
        }
        if (processed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "com/intellij/play/utils/PlayPathUtils", "collectCustomTags"));
        }
        if (processed.contains(module)) {
            return;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile virtualFile : roots = moduleRootManager.getSourceRoots()) {
            PsiDirectory directory;
            VirtualFile tagsDir = virtualFile.findFileByRelativePath("views/tags");
            if (tagsDir == null || !tagsDir.isDirectory() || (directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(tagsDir)) == null) continue;
            PlayPathUtils.addFiles(files, directory, "");
        }
        processed.add(module);
        for (VirtualFile virtualFile : moduleRootManager.getDependencies()) {
            PlayPathUtils.collectCustomTags((Module)virtualFile, files, processed);
        }
    }

    private static void addFiles(@NotNull Map<String, PsiFile> files, @NotNull PsiDirectory directory, @NotNull String relatedPath) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/play/utils/PlayPathUtils", "addFiles"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/play/utils/PlayPathUtils", "addFiles"));
        }
        if (relatedPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relatedPath", "com/intellij/play/utils/PlayPathUtils", "addFiles"));
        }
        for (PsiDirectory psiDirectory : directory.getSubdirectories()) {
            String dirName = psiDirectory.getName();
            PlayPathUtils.addFiles(files, psiDirectory, relatedPath.isEmpty() ? dirName : relatedPath + "." + dirName);
        }
        for (PsiDirectory psiDirectory : directory.getFiles()) {
            VirtualFile virtualFile;
            if (!(psiDirectory instanceof PlayPsiFile) || (virtualFile = psiDirectory.getVirtualFile()) == null) continue;
            String tagName = virtualFile.getNameWithoutExtension();
            files.put(relatedPath.isEmpty() ? tagName : relatedPath + "." + tagName, (PsiFile)psiDirectory);
        }
    }

    @Nullable
    public static PsiDirectory getViewsDirectory(@NotNull Module module) {
        VirtualFile[] roots;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/play/utils/PlayPathUtils", "getViewsDirectory"));
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile root : roots = moduleRootManager.getSourceRoots()) {
            VirtualFile viewsDir = root.findFileByRelativePath(VIEWS_PKG);
            if (viewsDir == null || !viewsDir.isDirectory()) continue;
            return PsiManager.getInstance((Project)module.getProject()).findDirectory(viewsDir);
        }
        return null;
    }

    @NotNull
    public static Set<PlayFastTagDescriptor> getFastTags(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/play/utils/PlayPathUtils", "getFastTags"));
        }
        HashSet fastTags = new HashSet();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        PsiClass fastTagsClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("play.templates.FastTags", scope);
        if (fastTagsClass != null) {
            Query classQuery = ClassInheritorsSearch.search((PsiClass)fastTagsClass, (SearchScope)scope, (boolean)true);
            for (PsiClass psiClass : classQuery.findAll()) {
                fastTags.addAll(PlayPathUtils.getFastTags(psiClass));
            }
        }
        HashSet hashSet = fastTags;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/utils/PlayPathUtils", "getFastTags"));
        }
        return hashSet;
    }

    @NotNull
    public static Set<PlayFastTagDescriptor> getFastTags(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/play/utils/PlayPathUtils", "getFastTags"));
        }
        HashSet fastTags = new HashSet();
        JamStringAttributeElement<String> namespace = PlayPathUtils.getFastTagNamespace(psiClass);
        for (PsiMethod method : psiClass.getMethods()) {
            if (!PlayPathUtils.isFastTagMethod(method)) continue;
            fastTags.add(new PlayFastTagDescriptor(method, namespace));
        }
        HashSet hashSet = fastTags;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/utils/PlayPathUtils", "getFastTags"));
        }
        return hashSet;
    }

    @Nullable
    private static JamStringAttributeElement<String> getFastTagNamespace(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/play/utils/PlayPathUtils", "getFastTagNamespace"));
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (String[])new String[]{"play.templates.FastTags.Namespace"});
        if (annotation == null) {
            return null;
        }
        return JamAttributeMeta.singleString((String)"value").getJam(PsiElementRef.real((PsiElement)annotation));
    }

    private static boolean isFastTagMethod(@NotNull PsiMethod method) {
        PsiParameter[] parameters;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/play/utils/PlayPathUtils", "isFastTagMethod"));
        }
        return method.getName().startsWith("_") && (parameters = method.getParameterList().getParameters()).length == 5;
    }
}

