/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.play.references.PlayControllerActionPsiReferenceProvider;
import com.intellij.play.utils.routes.RouterLineDescriptor;
import com.intellij.play.utils.routes.RouterUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.HashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayRoutesPsiReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiFile containingFile;
        Module module;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/play/references/PlayRoutesPsiReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/play/references/PlayRoutesPsiReferenceProvider", "getReferencesByElement"));
        }
        PsiElement originalElement = element.getOriginalElement();
        HashSet references = new HashSet();
        if (originalElement instanceof PsiFile && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement)) != null && (containingFile = element.getContainingFile()) != null) {
            PsiFile file = containingFile.getOriginalFile();
            Set descriptors = (Set)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.createSingleDependency(RouterUtils.getLineDescriptors(file.getText()), (Object)file));
            for (RouterLineDescriptor descriptor : descriptors) {
                references.addAll(PlayRoutesPsiReferenceProvider.getPathReferences(descriptor.getPath()));
                references.addAll(PlayRoutesPsiReferenceProvider.getActionReferences((PsiFile)originalElement, descriptor.getAction(), module));
            }
        }
        PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayRoutesPsiReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    @NotNull
    private static Set<PsiReference> getActionReferences(@NotNull PsiFile psiFile, @Nullable Pair<String, Integer> pair, @NotNull Module module) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/play/references/PlayRoutesPsiReferenceProvider", "getActionReferences"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/play/references/PlayRoutesPsiReferenceProvider", "getActionReferences"));
        }
        if (pair == null) {
            Set<PsiReference> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayRoutesPsiReferenceProvider", "getActionReferences"));
            }
            return set;
        }
        Set<PsiReference> set = PlayControllerActionPsiReferenceProvider.getActionNameReferences(psiFile.getChildren()[0], module, (String)pair.getFirst(), (Integer)pair.getSecond());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayRoutesPsiReferenceProvider", "getActionReferences"));
        }
        return set;
    }

    @NotNull
    private static Set<PsiReference> getPathReferences(@Nullable Pair<String, Integer> path) {
        if (path == null) {
            Set<PsiReference> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayRoutesPsiReferenceProvider", "getPathReferences"));
            }
            return set;
        }
        Set<PsiReference> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayRoutesPsiReferenceProvider", "getPathReferences"));
        }
        return set;
    }
}

