/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.references;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.CreatePropertyFix;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.play.utils.PlayPathUtils;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PlayPropertyReference
extends PropertyReference {
    public PlayPropertyReference(@NotNull String value, @NotNull PsiElement element) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/play/references/PlayPropertyReference", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/play/references/PlayPropertyReference", "<init>"));
        }
        super(value, element, null, false);
    }

    protected List<PropertiesFile> getPropertiesFiles() {
        ArrayList<PropertiesFile> propertiesFiles = new ArrayList<PropertiesFile>();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.getElement());
        if (module != null) {
            Set<PsiDirectory> directories = PlayPathUtils.getConfigDirectories(module);
            for (PsiDirectory directory : directories) {
                PsiFile[] files;
                for (PsiFile file : files = directory.getFiles()) {
                    if (!(file instanceof PropertiesFile) || !file.getName().startsWith("message")) continue;
                    propertiesFiles.add((PropertiesFile)file);
                }
            }
        }
        return propertiesFiles;
    }

    public LocalQuickFix[] getQuickFixes() {
        CreatePropertyFix fix = new CreatePropertyFix(this.myElement, this.myKey, this.getPropertiesFiles());
        return new LocalQuickFix[]{fix};
    }
}

