/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.navigation;

import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.play.language.psi.PlayPsiFile;
import com.intellij.play.utils.PlayPathUtils;
import com.intellij.play.utils.PlayUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PlayGotoRelatedFileProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/play/navigation/PlayGotoRelatedFileProvider", "getItems"));
        }
        ArrayList<GotoRelatedItem> items = new ArrayList<GotoRelatedItem>();
        if (PlayUtils.isPlayInstalled(psiElement.getProject())) {
            PsiMethod[] controller;
            PsiDirectory directory;
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
            if (psiClass != null && (directory = PlayPathUtils.getCorrespondingDirectory(psiClass)) != null) {
                for (PsiFile file : directory.getFiles()) {
                    if (!(file instanceof PlayPsiFile)) continue;
                    items.add(new GotoRelatedItem((PsiElement)file));
                }
            }
            PsiFile psiFile = psiElement.getContainingFile();
            for (final PsiMethod method : controller = PlayPathUtils.getCorrespondingControllerMethods(psiFile)) {
                items.add(new GotoRelatedItem((PsiElement)method){

                    public Icon getCustomIcon() {
                        return method.getIcon(0);
                    }
                });
            }
        }
        ArrayList<GotoRelatedItem> arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/navigation/PlayGotoRelatedFileProvider", "getItems"));
        }
        return arrayList;
    }

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/play/navigation/PlayGotoRelatedFileProvider", "getItems"));
        }
        List list = super.getItems(context);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/navigation/PlayGotoRelatedFileProvider", "getItems"));
        }
        return list;
    }
}

