/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.language.lexer;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.play.language.PlayElementTypes;
import com.intellij.play.language.PlayTokenType;
import com.intellij.play.language.lexer._PlayLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayLexer
extends LookAheadLexer {
    public static final TokenSet START_MARKUP_TOKENS = TokenSet.create((IElementType[])new IElementType[]{PlayElementTypes.EL_START, PlayElementTypes.ACTION_START, PlayElementTypes.ACTION_END, PlayElementTypes.MESSAGE_START, PlayElementTypes.ACTION_DOUBLE_START, PlayElementTypes.TAG_START, PlayElementTypes.END_TAG_START, PlayElementTypes.PERCENT, PlayElementTypes.ASTERISK});
    private final TokenSet BRACKETS_SET = TokenSet.create((IElementType[])new IElementType[]{PlayElementTypes.LEFT_PAREN, PlayElementTypes.RIGHT_PAREN, PlayElementTypes.LEFT_BRACKET, PlayElementTypes.RIGHT_BRACKET, PlayElementTypes.LEFT_BRACE});

    protected PlayLexer(_PlayLexer rawLexer) {
        super((Lexer)new FlexAdapter((FlexLexer)rawLexer));
    }

    @Nullable
    protected IElementType mergeTokens(Lexer baseLexer, TokenSet until, IElementType intoType) {
        if (PlayLexer.skipTokens(baseLexer, until)) {
            this.addToken(baseLexer.getTokenStart(), intoType);
        }
        return baseLexer.getTokenType();
    }

    protected static boolean currentOrSkipTokens(Lexer baseLexer, TokenSet until) {
        return until.contains(baseLexer.getTokenType()) || PlayLexer.skipTokens(baseLexer, until);
    }

    protected static boolean skipTokens(Lexer baseLexer, TokenSet until) {
        boolean skipped = false;
        IElementType tokenType;
        while ((tokenType = baseLexer.getTokenType()) != null && !until.contains(tokenType)) {
            skipped = true;
            baseLexer.advance();
        }
        return skipped;
    }

    protected void lookAhead(Lexer baseLexer) {
        this.mergeTokens(baseLexer, START_MARKUP_TOKENS, (IElementType)PlayElementTypes.TEMPLATE_TEXT);
        IElementType tokenType = baseLexer.getTokenType();
        if (tokenType == PlayElementTypes.ACTION_START || tokenType == PlayElementTypes.ACTION_DOUBLE_START) {
            this.tokenizeAction(baseLexer);
        } else if (tokenType == PlayElementTypes.MESSAGE_START) {
            this.tokenizeMessage(baseLexer);
        } else if (tokenType == PlayElementTypes.EL_START) {
            this.tokenizeExpression(baseLexer);
        } else if (tokenType == PlayElementTypes.TAG_START || tokenType == PlayElementTypes.END_TAG_START) {
            this.tokenizeTag(baseLexer);
        } else if (tokenType == PlayElementTypes.ASTERISK) {
            baseLexer.advance();
            if (baseLexer.getTokenType() == PlayElementTypes.LEFT_BRACE) {
                this.advanceAs(baseLexer, (IElementType)PlayElementTypes.COMMENT_START);
                this.tokenize(baseLexer, PlayElementTypes.COMMENT_TEXT, PlayElementTypes.COMMENT_END, PlayElementTypes.ASTERISK, false);
            } else {
                this.addToken(baseLexer.getTokenStart(), (IElementType)PlayElementTypes.TEMPLATE_TEXT);
            }
        } else {
            super.lookAhead(baseLexer);
        }
    }

    private void tokenizeScript(Lexer baseLexer) {
        this.tokenize(baseLexer, PlayElementTypes.GROOVY_SCRIPT, PlayElementTypes.SCRIPT_END, PlayElementTypes.PERCENT, false);
    }

    private void tokenize(Lexer baseLexer, PlayTokenType bodyType, PlayTokenType endType, IElementType endSymbol, boolean addScriptNode) {
        TokenSet set = TokenSet.create((IElementType[])new IElementType[]{PlayElementTypes.RIGHT_BRACE});
        if (baseLexer.getTokenType() == PlayElementTypes.RIGHT_BRACE) {
            int tokenStart = baseLexer.getTokenStart();
            baseLexer.advance();
            if (baseLexer.getTokenType() == endSymbol) {
                if (addScriptNode) {
                    this.addToken(tokenStart, (IElementType)bodyType);
                }
                this.advanceWithRepalce(baseLexer, (IElementType)endType);
            }
        } else if (PlayLexer.skipTokens(baseLexer, set)) {
            int tokenStart = baseLexer.getTokenStart();
            baseLexer.advance();
            if (baseLexer.getTokenType() == endSymbol) {
                this.addToken(tokenStart, (IElementType)bodyType);
                this.advanceWithRepalce(baseLexer, (IElementType)endType);
            } else {
                this.tokenize(baseLexer, bodyType, endType, endSymbol, true);
            }
        } else {
            this.advanceAs(baseLexer, (IElementType)bodyType);
        }
    }

    private void tokenizeExpression(Lexer baseLexer) {
        this.advanceLexer(baseLexer);
        this.mergeToRightBrace(baseLexer, PlayElementTypes.EL_EXPRESSION, (IElementType)PlayElementTypes.EL_END);
    }

    private void tokenizeTag(Lexer baseLexer) {
        boolean isStartTag = baseLexer.getTokenType() == PlayElementTypes.TAG_START;
        this.advanceLexer(baseLexer);
        this.mergeTokens(baseLexer, TokenSet.create((IElementType[])new IElementType[]{PlayElementTypes.RIGHT_BRACE, PlayElementTypes.WHITE_SPACE, PlayElementTypes.CLOSE_TAG}), (IElementType)PlayElementTypes.TAG_NAME);
        this.addWhiteSpaces(baseLexer);
        if (isStartTag) {
            this.tokenizeTagExpression(baseLexer);
        } else {
            this.mergeToTagEnd(baseLexer);
        }
    }

    private void tokenizeTagExpression(Lexer baseLexer) {
        this.tokenizeTagExpression(baseLexer, TokenSet.create((IElementType[])new IElementType[]{PlayElementTypes.TAG_START, PlayElementTypes.RIGHT_BRACE, PlayElementTypes.CLOSE_TAG, PlayElementTypes.COMMA, PlayElementTypes.COLON, PlayElementTypes.SINGLE_QUOTE, PlayElementTypes.DOUBLE_QUOTE}));
    }

    private boolean tokenizeTagExpression(Lexer baseLexer, TokenSet until) {
        this.addWhiteSpaces(baseLexer);
        if (baseLexer.getTokenType() == PlayElementTypes.RIGHT_BRACE || baseLexer.getTokenType() == PlayElementTypes.CLOSE_TAG) {
            this.advanceTagEnd(baseLexer);
        } else if (baseLexer.getTokenType() == PlayElementTypes.AT) {
            this.advanceLexer(baseLexer);
            this.tokenizeExpression(baseLexer, until, PlayElementTypes.ACTION_SCRIPT);
        } else if (baseLexer.getTokenType() == PlayElementTypes.TAG_START || baseLexer.getTokenType() == PlayElementTypes.END_TAG_START) {
            this.tokenizeTag(baseLexer);
        } else {
            this.tokenizeExpression(baseLexer, until, PlayElementTypes.TAG_EXPRESSION);
        }
        return true;
    }

    private boolean tokenizeExpression(Lexer baseLexer, TokenSet until, IElementType type) {
        return this.tokenizeExpression(baseLexer, until, type, new CounterHelper(baseLexer.getTokenEnd()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tokenizeExpression(Lexer baseLexer, TokenSet until, IElementType type, @NotNull CounterHelper counter) {
        TokenSet startBracketSet;
        if (counter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/play/language/lexer/PlayLexer", "tokenizeExpression"));
        }
        IElementType tokenType = baseLexer.getTokenType();
        if (tokenType == PlayElementTypes.SINGLE_QUOTE || tokenType == PlayElementTypes.DOUBLE_QUOTE) {
            return this.tokenizeExpressionWithQuotes(baseLexer, until, type, counter, tokenType);
        }
        if (counter.hasNestingBrackets()) {
            if (TokenSet.orSet((TokenSet[])new TokenSet[]{this.BRACKETS_SET, TokenSet.create((IElementType[])new IElementType[]{PlayElementTypes.RIGHT_BRACE})}).contains(baseLexer.getTokenType())) {
                PlayLexer.countBrackets(baseLexer, counter);
                baseLexer.advance();
                if (baseLexer.getTokenType() != null) return this.tokenizeExpression(baseLexer, until, type, counter);
                this.addToken(baseLexer.getTokenStart(), type);
            } else {
                if (PlayLexer.skipTokens(baseLexer, TokenSet.orSet((TokenSet[])new TokenSet[]{this.BRACKETS_SET, TokenSet.create((IElementType[])new IElementType[]{PlayElementTypes.CLOSE_TAG})}))) {
                    if (baseLexer.getTokenType() == PlayElementTypes.CLOSE_TAG) {
                        this.addToken(baseLexer.getTokenStart(), type);
                        return this.completeTokenizeExpression(baseLexer);
                    }
                    PlayLexer.countBrackets(baseLexer, counter);
                    baseLexer.advance();
                    return this.tokenizeExpression(baseLexer, until, type, counter);
                }
                this.addToken(baseLexer.getTokenStart(), type);
                return this.completeTokenizeExpression(baseLexer);
            }
        }
        if (!PlayLexer.currentOrSkipTokens(baseLexer, TokenSet.orSet((TokenSet[])new TokenSet[]{until, startBracketSet = TokenSet.create((IElementType[])new IElementType[]{PlayElementTypes.LEFT_PAREN, PlayElementTypes.LEFT_BRACKET, PlayElementTypes.LEFT_BRACE})}))) return this.completeTokenizeExpression(baseLexer);
        if (this.BRACKETS_SET.contains(baseLexer.getTokenType())) {
            PlayLexer.countBrackets(baseLexer, counter);
            baseLexer.advance();
            return this.tokenizeExpression(baseLexer, until, type, counter);
        }
        IElementType elementType = baseLexer.getTokenType();
        if (elementType == PlayElementTypes.SINGLE_QUOTE || elementType == PlayElementTypes.DOUBLE_QUOTE) {
            return this.tokenizeExpressionWithQuotes(baseLexer, until, type, counter, elementType);
        }
        if (baseLexer.getTokenType() == PlayElementTypes.COLON) {
            if (counter.lexerWasAdvanced(baseLexer)) {
                this.addToken(baseLexer.getTokenStart(), (IElementType)PlayElementTypes.ATTR_NAME);
                this.advanceLexer(baseLexer);
                return this.tokenizeTagExpression(baseLexer, TokenSet.create((IElementType[])new IElementType[]{PlayElementTypes.TAG_START, PlayElementTypes.RIGHT_BRACE, PlayElementTypes.CLOSE_TAG, PlayElementTypes.COMMA, PlayElementTypes.SINGLE_QUOTE, PlayElementTypes.DOUBLE_QUOTE}));
            }
            baseLexer.advance();
            return this.tokenizeExpression(baseLexer, until, type, counter);
        }
        if (baseLexer.getTokenType() == PlayElementTypes.TAG_START) {
            this.addToken(baseLexer.getTokenStart(), type);
            this.tokenizeTag(baseLexer);
            return true;
        }
        if (!counter.lexerWasAdvanced(baseLexer) && baseLexer.getTokenType() != null) return this.completeTokenizeExpression(baseLexer);
        this.addToken(baseLexer.getTokenStart(), type);
        return this.completeTokenizeExpression(baseLexer);
    }

    private static void countBrackets(Lexer baseLexer, CounterHelper counter) {
        IElementType tokenType = baseLexer.getTokenType();
        if (tokenType == PlayElementTypes.LEFT_BRACKET) {
            ++counter.bracketNesting;
        } else if (tokenType == PlayElementTypes.LEFT_BRACE) {
            ++counter.braceNesting;
        } else if (tokenType == PlayElementTypes.LEFT_PAREN) {
            ++counter.parenNesting;
        } else if (tokenType == PlayElementTypes.RIGHT_BRACKET && counter.bracketNesting > 0) {
            --counter.bracketNesting;
        } else if (tokenType == PlayElementTypes.RIGHT_BRACE && counter.braceNesting > 0) {
            --counter.braceNesting;
        } else if (tokenType == PlayElementTypes.RIGHT_PAREN && counter.parenNesting > 0) {
            --counter.parenNesting;
        }
    }

    private boolean tokenizeExpressionWithQuotes(Lexer baseLexer, TokenSet until, IElementType type, CounterHelper counter, IElementType quote) {
        if (baseLexer.getTokenType() == quote) {
            this.advanceQuotes(baseLexer, type, quote);
        }
        if (counter.hasNestingBrackets()) {
            return this.tokenizeExpression(baseLexer, until, type, counter);
        }
        if (baseLexer.getTokenType() == PlayElementTypes.COMMA) {
            this.addToken(baseLexer.getTokenStart(), type);
            this.completeTokenizeExpression(baseLexer);
            return true;
        }
        if (until.contains(baseLexer.getTokenType())) {
            this.addToken(baseLexer.getTokenStart(), type);
            this.completeTokenizeExpression(baseLexer);
        } else {
            this.tokenizeExpression(baseLexer, until, type);
        }
        return true;
    }

    private boolean completeTokenizeExpression(Lexer baseLexer) {
        if (baseLexer.getTokenType() == PlayElementTypes.COMMA) {
            this.advanceLexer(baseLexer);
            this.tokenizeTagExpression(baseLexer);
        } else if (baseLexer.getTokenType() == PlayElementTypes.TAG_START) {
            this.tokenizeTag(baseLexer);
        } else {
            this.mergeToTagEnd(baseLexer);
        }
        return true;
    }

    private boolean advanceQuotes(Lexer baseLexer, IElementType type, IElementType quote) {
        baseLexer.advance();
        if (baseLexer.getTokenType() == null) {
            this.advanceAs(baseLexer, PlayElementTypes.BAD_CHARACTER);
        } else if (PlayLexer.currentOrSkipTokens(baseLexer, TokenSet.create((IElementType[])new IElementType[]{quote}))) {
            if (baseLexer.getTokenType() == null) {
                this.advanceAs(baseLexer, PlayElementTypes.BAD_CHARACTER);
            } else {
                baseLexer.advance();
                if (baseLexer.getTokenType() == null) {
                    this.addToken(baseLexer.getTokenStart(), type);
                }
            }
            return true;
        }
        return false;
    }

    private void mergeToTagEnd(Lexer baseLexer) {
        if (baseLexer.getTokenType() == PlayElementTypes.RIGHT_BRACE || baseLexer.getTokenType() == PlayElementTypes.CLOSE_TAG) {
            this.advanceTagEnd(baseLexer);
        } else {
            this.addWhiteSpaces(baseLexer);
            if (baseLexer.getTokenType() == PlayElementTypes.RIGHT_BRACE || baseLexer.getTokenType() == PlayElementTypes.CLOSE_TAG) {
                this.advanceTagEnd(baseLexer);
            }
        }
    }

    private void advanceTagEnd(Lexer baseLexer) {
        if (baseLexer.getTokenType() == PlayElementTypes.RIGHT_BRACE) {
            this.advanceAs(baseLexer, (IElementType)PlayElementTypes.TAG_END);
        } else {
            this.advanceLexer(baseLexer);
        }
    }

    private void mergeToRightBrace(Lexer baseLexer, @NotNull IElementType expressionType, @Nullable IElementType replaceBraceWith) {
        if (expressionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionType", "com/intellij/play/language/lexer/PlayLexer", "mergeToRightBrace"));
        }
        this.mergeToRightBrace(baseLexer, TokenSet.create((IElementType[])new IElementType[]{PlayElementTypes.RIGHT_BRACE}), expressionType, replaceBraceWith, new CounterHelper());
    }

    protected void mergeTo(Lexer baseLexer, @NotNull TokenSet mergeTo, @NotNull IElementType expressionType, @Nullable IElementType replaceBraceWith) {
        if (mergeTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeTo", "com/intellij/play/language/lexer/PlayLexer", "mergeTo"));
        }
        if (expressionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionType", "com/intellij/play/language/lexer/PlayLexer", "mergeTo"));
        }
        if (mergeTo.contains(baseLexer.getTokenType())) {
            this.advanceWithRepalce(baseLexer, replaceBraceWith);
        } else if (PlayLexer.skipTokens(baseLexer, mergeTo)) {
            this.addToken(baseLexer.getTokenStart(), expressionType);
            this.advanceWithRepalce(baseLexer, replaceBraceWith);
        }
    }

    protected void mergeToRightBrace(Lexer baseLexer, @NotNull TokenSet mergeTo, @NotNull IElementType expressionType, @Nullable IElementType replaceBraceWith, @NotNull CounterHelper counter) {
        if (mergeTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeTo", "com/intellij/play/language/lexer/PlayLexer", "mergeToRightBrace"));
        }
        if (expressionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionType", "com/intellij/play/language/lexer/PlayLexer", "mergeToRightBrace"));
        }
        if (counter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/play/language/lexer/PlayLexer", "mergeToRightBrace"));
        }
        IElementType tokenType = baseLexer.getTokenType();
        if (mergeTo.contains(tokenType)) {
            this.advanceWithRepalce(baseLexer, replaceBraceWith);
        } else if (PlayLexer.currentOrSkipTokens(baseLexer, TokenSet.orSet((TokenSet[])new TokenSet[]{mergeTo, TokenSet.create((IElementType[])new IElementType[]{PlayElementTypes.RIGHT_BRACE, PlayElementTypes.LEFT_BRACE})}))) {
            IElementType currentTokenType = baseLexer.getTokenType();
            if (currentTokenType == PlayElementTypes.LEFT_BRACE || currentTokenType == PlayElementTypes.RIGHT_BRACE && counter.braceNesting > 0) {
                PlayLexer.countBrackets(baseLexer, counter);
                baseLexer.advance();
                this.mergeToRightBrace(baseLexer, mergeTo, expressionType, replaceBraceWith, counter);
            } else {
                this.addToken(baseLexer.getTokenStart(), expressionType);
                if (baseLexer.getTokenType() != null) {
                    this.advanceWithRepalce(baseLexer, replaceBraceWith);
                }
            }
        } else {
            this.advanceWithRepalce(baseLexer, replaceBraceWith);
        }
    }

    private void advanceWithRepalce(Lexer baseLexer, IElementType replaceBraceWith) {
        if (replaceBraceWith != null) {
            this.advanceAs(baseLexer, replaceBraceWith);
        } else {
            this.advanceLexer(baseLexer);
        }
    }

    private void addWhiteSpaces(Lexer baseLexer) {
        while (baseLexer.getTokenType() == PlayElementTypes.WHITE_SPACE) {
            this.addToken(PlayElementTypes.WHITE_SPACE);
            baseLexer.advance();
        }
    }

    private void tokenizeComment(Lexer baseLexer) {
        this.advanceLexer(baseLexer);
        this.mergeTo(baseLexer, TokenSet.create((IElementType[])new IElementType[]{PlayElementTypes.COMMENT_END}), (IElementType)PlayElementTypes.COMMENT_TEXT, null);
    }

    private void tokenizeAction(Lexer baseLexer) {
        this.advanceLexer(baseLexer);
        this.mergeToRightBrace(baseLexer, PlayElementTypes.ACTION_SCRIPT, (IElementType)PlayElementTypes.ACTION_END);
    }

    private void tokenizeMessage(Lexer baseLexer) {
        this.advanceLexer(baseLexer);
        this.tokenizeMessage(baseLexer, new CounterHelper(baseLexer.getTokenEnd()));
    }

    private void tokenizeMessage(Lexer baseLexer, @NotNull CounterHelper counter) {
        if (counter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/play/language/lexer/PlayLexer", "tokenizeMessage"));
        }
        IElementType tokenType = baseLexer.getTokenType();
        if (tokenType == PlayElementTypes.RIGHT_BRACE) {
            if (counter.lexerWasAdvanced(baseLexer)) {
                this.addToken(baseLexer.getTokenStart(), PlayElementTypes.MESSAGE_TEXT);
            }
            this.advanceWithRepalce(baseLexer, (IElementType)PlayElementTypes.MESSAGE_END);
        } else {
            TokenSet set = TokenSet.create((IElementType[])new IElementType[]{PlayElementTypes.COMMA, PlayElementTypes.RIGHT_BRACE, PlayElementTypes.LEFT_BRACE, PlayElementTypes.SINGLE_QUOTE});
            if (PlayLexer.currentOrSkipTokens(baseLexer, set)) {
                IElementType currentTokenType = baseLexer.getTokenType();
                if (currentTokenType == PlayElementTypes.SINGLE_QUOTE) {
                    if (baseLexer.getTokenType() == PlayElementTypes.SINGLE_QUOTE) {
                        if (this.advanceQuotes(baseLexer, PlayElementTypes.MESSAGE_TEXT, (IElementType)PlayElementTypes.SINGLE_QUOTE) && baseLexer.getTokenType() != PlayElementTypes.BAD_CHARACTER) {
                            this.tokenizeMessage(baseLexer, counter);
                            return;
                        }
                        this.advanceAs(baseLexer, PlayElementTypes.BAD_CHARACTER);
                        return;
                    }
                } else if (currentTokenType == PlayElementTypes.LEFT_BRACE || currentTokenType == PlayElementTypes.RIGHT_BRACE && counter.braceNesting > 0) {
                    PlayLexer.countBrackets(baseLexer, counter);
                    baseLexer.advance();
                    this.tokenizeMessage(baseLexer, counter);
                } else if (currentTokenType == PlayElementTypes.COMMA && !counter.hasNestingBrackets()) {
                    if (counter.lexerWasAdvanced(baseLexer)) {
                        this.addToken(baseLexer.getTokenStart(), PlayElementTypes.MESSAGE_TEXT);
                    }
                    this.advanceLexer(baseLexer);
                    this.tokenizeMessage(baseLexer, new CounterHelper(baseLexer.getTokenEnd()));
                } else {
                    this.addToken(baseLexer.getTokenStart(), PlayElementTypes.MESSAGE_TEXT);
                    if (baseLexer.getTokenType() != null) {
                        this.advanceWithRepalce(baseLexer, (IElementType)PlayElementTypes.MESSAGE_END);
                        return;
                    }
                }
            } else if (baseLexer.getTokenType() != null) {
                this.advanceWithRepalce(baseLexer, (IElementType)PlayElementTypes.MESSAGE_END);
            }
        }
    }

    public static PlayLexer createLexer() {
        return new PlayLexer(new _PlayLexer());
    }

    private class CounterHelper {
        public int parenNesting = 0;
        public int bracketNesting = 0;
        public int braceNesting = 0;
        public int lastLexerPosition = -1;

        private CounterHelper() {
        }

        public CounterHelper(int lexerPosition) {
            this.lastLexerPosition = lexerPosition;
        }

        public boolean lexerWasAdvanced(Lexer baseLexer) {
            return this.lastLexerPosition != baseLexer.getTokenEnd();
        }

        public boolean hasNestingBrackets() {
            return this.parenNesting != 0 || this.braceNesting != 0 || this.bracketNesting != 0;
        }
    }
}

