/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.language;

import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcherEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PlayMessagesFileTypeFactory
extends FileTypeFactory {
    private static final String FILE_NAME = "messages";
    private static final Set<String> LANGUAGE_FILENAMES = ContainerUtil.map2Set((Object[])Locale.getAvailableLocales(), locale -> "messages." + locale.getLanguage());

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/play/language/PlayMessagesFileTypeFactory", "createFileTypes"));
        }
        consumer.consume((FileType)PropertiesFileType.INSTANCE, new FileNameMatcher[]{new ExactFileNameMatcher(FILE_NAME), new FileNameMatcherEx(){

            public boolean acceptsCharSequence(@NotNull CharSequence fileName) {
                if (fileName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/play/language/PlayMessagesFileTypeFactory$1", "acceptsCharSequence"));
                }
                return StringUtil.startsWith((CharSequence)fileName, (CharSequence)PlayMessagesFileTypeFactory.FILE_NAME) && LANGUAGE_FILENAMES.contains(fileName.toString());
            }

            @NotNull
            public String getPresentableString() {
                if ("messages.*" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/PlayMessagesFileTypeFactory$1", "getPresentableString"));
                }
                return "messages.*";
            }
        }});
    }
}

