/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.language;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.play.language.PlayLanguage;
import com.intellij.play.utils.PlayUtils;
import com.intellij.psi.LanguageSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayLanguageSubstitutor
extends LanguageSubstitutor {
    public Language getLanguage(@NotNull VirtualFile file, @NotNull Project project) {
        VirtualFile tagsDir;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/play/language/PlayLanguageSubstitutor", "getLanguage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/play/language/PlayLanguageSubstitutor", "getLanguage"));
        }
        if (file instanceof VirtualFileWindow) {
            return null;
        }
        if (file.getFileType() == StdFileTypes.HTML && PlayLanguageSubstitutor.checkViewsParent(file) && PlayUtils.isPlayInstalled(project)) {
            return PlayLanguage.INSTANCE;
        }
        if ("tag".equals(file.getExtension()) && PlayLanguageSubstitutor.checkDirName(tagsDir = file.getParent(), "tags") && PlayLanguageSubstitutor.checkDirName(tagsDir.getParent(), "views") && PlayUtils.isPlayInstalled(project)) {
            return PlayLanguage.INSTANCE;
        }
        return null;
    }

    private static boolean checkDirName(@Nullable VirtualFile tagsDir, @NotNull String dirName) {
        if (dirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirName", "com/intellij/play/language/PlayLanguageSubstitutor", "checkDirName"));
        }
        return tagsDir != null && dirName.equals(tagsDir.getName());
    }

    private static boolean checkViewsParent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/play/language/PlayLanguageSubstitutor", "checkViewsParent"));
        }
        for (VirtualFile parent = file.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.isDirectory() || !"views".equals(parent.getName())) continue;
            return true;
        }
        return false;
    }
}

