/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.completion.beans;

import com.intellij.jam.JamStringAttributeElement;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayFastTagDescriptor {
    @NotNull
    private final PsiMethod myMethod;
    @Nullable
    private final JamStringAttributeElement<String> myNamespace;

    public PlayFastTagDescriptor(@NotNull PsiMethod method, @Nullable JamStringAttributeElement<String> namespace) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/play/completion/beans/PlayFastTagDescriptor", "<init>"));
        }
        this.myMethod = method;
        assert (this.myMethod.getName().startsWith("_"));
        this.myNamespace = namespace;
    }

    @NotNull
    public PsiMethod getMethod() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/completion/beans/PlayFastTagDescriptor", "getMethod"));
        }
        return psiMethod;
    }

    @Nullable
    public JamStringAttributeElement<String> getNamespace() {
        return this.myNamespace;
    }

    @Nullable
    public String getNamespaceValue() {
        JamStringAttributeElement<String> namespace = this.getNamespace();
        return namespace == null || namespace.getValue() == null ? "" : (String)namespace.getValue();
    }

    public String getName() {
        return this.myMethod.getName().substring(1);
    }

    public String getFqn() {
        return this.getNamespaceValue() + "." + this.getName();
    }
}

