/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomImport;
import com.intellij.lang.ant.dom.AntDomInclude;
import com.intellij.lang.ant.dom.AntDomIncludingDirective;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntDomRecursiveVisitor;
import com.intellij.lang.ant.dom.AntDomTarget;
import com.intellij.lang.ant.dom.PropertiesProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyProviderFinder
extends AntDomRecursiveVisitor {
    private Stage myStage = Stage.RESOLVE_MAP_BUILDING_STAGE;
    private final Stack<String> myCurrentTargetEffectiveName = new Stack();
    private final AntDomElement myContextElement;
    private boolean myStopped;
    private final TargetsNameContext myNameContext = new TargetsNameContext();
    private final Map<String, AntDomTarget> myTargetsResolveMap = new HashMap();
    private final Map<String, List<String>> myDependenciesMap = new HashMap();
    private final Set<String> myProcessedTargets = new HashSet<String>();
    private final Set<AntDomProject> myVisitedProjects = new HashSet<AntDomProject>();

    protected static <K, V> void cacheResult(@Nullable DomElement context, Key<Map<K, V>> cacheKind, K key, V value) {
        if (context != null) {
            Map<K, V> cachemap = (Map<K, V>)cacheKind.get((UserDataHolder)context);
            if (cachemap == null) {
                cachemap = Collections.synchronizedMap(new HashMap());
                cacheKind.set((UserDataHolder)context, cachemap);
            }
            cachemap.put(key, value);
        }
    }

    protected PropertyProviderFinder(DomElement contextElement) {
        this.myContextElement = contextElement != null ? (AntDomElement)contextElement.getParentOfType(AntDomElement.class, false) : null;
    }

    public void execute(AntDomProject startProject, String initialTargetName) {
        this.myStage = Stage.RESOLVE_MAP_BUILDING_STAGE;
        startProject.accept(this);
        this.stageCompleted(Stage.RESOLVE_MAP_BUILDING_STAGE, Stage.TARGETS_WALKUP_STAGE);
        if (!this.myStopped) {
            AntDomTarget target;
            this.myStage = Stage.TARGETS_WALKUP_STAGE;
            AntDomTarget antDomTarget = target = initialTargetName != null ? this.getTargetByName(initialTargetName) : null;
            if (target != null) {
                this.processTarget(initialTargetName, target);
            }
            ArrayList<String> unprocessed = null;
            for (String s : this.myTargetsResolveMap.keySet()) {
                if (this.myProcessedTargets.contains(s)) continue;
                if (unprocessed == null) {
                    unprocessed = new ArrayList<String>();
                }
                unprocessed.add(s);
            }
            if (unprocessed != null) {
                for (String targetName : unprocessed) {
                    this.processTarget(targetName, this.myTargetsResolveMap.get(targetName));
                }
            }
        }
    }

    private void processTarget(String targetEffectiveName, AntDomTarget target) {
        this.myCurrentTargetEffectiveName.push(targetEffectiveName);
        try {
            target.accept(this);
        }
        finally {
            this.myCurrentTargetEffectiveName.pop();
        }
    }

    @Override
    public void visitTarget(AntDomTarget target) {
        if (this.myStage == Stage.TARGETS_WALKUP_STAGE) {
            String targetEffectiveName = this.myCurrentTargetEffectiveName.peek();
            if (this.myProcessedTargets.add(targetEffectiveName)) {
                List<String> depsList = this.myDependenciesMap.get(targetEffectiveName);
                if (depsList != null) {
                    for (String dependencyName : depsList) {
                        AntDomTarget dependency = this.getTargetByName(dependencyName);
                        if (dependency == null) continue;
                        this.processTarget(dependencyName, dependency);
                    }
                }
                super.visitTarget(target);
            }
        } else if (this.myStage == Stage.RESOLVE_MAP_BUILDING_STAGE) {
            String declaredTargetName = target.getName().getRawText();
            String effectiveTargetName = null;
            InclusionKind inclusionKind = this.myNameContext.getCurrentInclusionKind();
            switch (inclusionKind) {
                case IMPORT: {
                    String alias = this.myNameContext.getShortPrefix() + declaredTargetName;
                    if (!this.myTargetsResolveMap.containsKey(declaredTargetName)) {
                        effectiveTargetName = declaredTargetName;
                        this.myTargetsResolveMap.put(alias, target);
                        break;
                    }
                    effectiveTargetName = alias;
                    break;
                }
                case INCLUDE: {
                    effectiveTargetName = this.myNameContext.getFQPrefix() + declaredTargetName;
                    break;
                }
                default: {
                    effectiveTargetName = declaredTargetName;
                }
            }
            if (effectiveTargetName != null) {
                AntDomTarget existingTarget = this.myTargetsResolveMap.get(effectiveTargetName);
                if (existingTarget != null && Comparing.equal((Object)existingTarget.getAntProject(), (Object)target.getAntProject())) {
                    this.duplicateTargetFound(existingTarget, target, effectiveTargetName);
                } else {
                    this.myTargetsResolveMap.put(effectiveTargetName, target);
                    String dependsStr = target.getDependsList().getRawText();
                    HashMap depsMap = Collections.emptyMap();
                    if (dependsStr != null) {
                        depsMap = new HashMap();
                        StringTokenizer tokenizer = new StringTokenizer(dependsStr, ",", false);
                        while (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken().trim();
                            String dependentTargetEffectiveName = this.myNameContext.calcTargetReferenceText(token);
                            AntDomTarget dependent = this.getTargetByName(dependentTargetEffectiveName);
                            if (dependent != null) {
                                depsMap.put(token, Pair.create((Object)dependent, (Object)dependentTargetEffectiveName));
                            }
                            this.addDependency(effectiveTargetName, dependentTargetEffectiveName);
                        }
                    }
                    this.targetDefined(target, effectiveTargetName, (Map<String, Pair<AntDomTarget, String>>)depsMap);
                }
            }
        }
    }

    @Override
    public void visitAntDomElement(AntDomElement element) {
        if (this.myStopped) {
            return;
        }
        if (element.equals(this.myContextElement)) {
            this.stop();
        } else if (element instanceof PropertiesProvider) {
            this.propertyProviderFound((PropertiesProvider)((Object)element));
        }
        if (!this.myStopped) {
            Iterator<AntDomElement> iterator = element.getAntChildrenIterator();
            while (iterator.hasNext()) {
                AntDomElement child = iterator.next();
                child.accept(this);
                if (this.myStage != Stage.TARGETS_WALKUP_STAGE || !this.myStopped) continue;
                break;
            }
        }
    }

    @Nullable
    protected AntDomTarget getTargetByName(String effectiveName) {
        return this.myTargetsResolveMap.get(effectiveName);
    }

    @NotNull
    public final Map<String, AntDomTarget> getDiscoveredTargets() {
        Map<String, AntDomTarget> map = Collections.unmodifiableMap(this.myTargetsResolveMap);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/PropertyProviderFinder", "getDiscoveredTargets"));
        }
        return map;
    }

    public AntDomElement getContextElement() {
        return this.myContextElement;
    }

    protected void stop() {
        this.myStopped = true;
    }

    protected abstract void propertyProviderFound(PropertiesProvider var1);

    @Override
    public void visitInclude(AntDomInclude includeTag) {
        this.processFileInclusion(includeTag, InclusionKind.INCLUDE);
    }

    @Override
    public void visitImport(AntDomImport importTag) {
        this.processFileInclusion(importTag, InclusionKind.IMPORT);
    }

    @Override
    public void visitProject(AntDomProject project) {
        if (this.myVisitedProjects.add(project)) {
            try {
                super.visitProject(project);
            }
            finally {
                this.myVisitedProjects.remove(project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFileInclusion(AntDomIncludingDirective directive, InclusionKind kind) {
        if (directive.equals(this.myContextElement)) {
            this.stop();
        }
        if (this.myStopped) {
            return;
        }
        PsiFileSystemItem item = (PsiFileSystemItem)directive.getFile().getValue();
        if (item instanceof PsiFile) {
            AntDomProject slaveProject;
            AntDomProject antDomProject = slaveProject = item instanceof XmlFile ? AntSupport.getAntDomProjectForceAntFile((PsiFile)((XmlFile)item)) : null;
            if (slaveProject != null) {
                this.myNameContext.pushPrefix(directive, kind, slaveProject);
                try {
                    slaveProject.accept(this);
                }
                finally {
                    this.myNameContext.popPrefix();
                }
            }
        }
    }

    private void addDependency(String effectiveTargetName, String dependentTargetEffectiveName) {
        List<String> list = this.myDependenciesMap.get(effectiveTargetName);
        if (list == null) {
            list = new ArrayList<String>();
            this.myDependenciesMap.put(effectiveTargetName, list);
        }
        list.add(dependentTargetEffectiveName);
    }

    protected void targetDefined(AntDomTarget target, String taregetEffectiveName, Map<String, Pair<AntDomTarget, String>> dependenciesMap) {
    }

    protected void duplicateTargetFound(AntDomTarget existingTarget, AntDomTarget duplicatingTarget, String taregetEffectiveName) {
    }

    protected void stageCompleted(Stage completedStage, Stage startingStage) {
    }

    private static class TargetsNameContext {
        private int myDefaultPrefixCounter = 0;
        private final LinkedList<Pair<String, InclusionKind>> myPrefixes = new LinkedList();
        private String myCurrentPrefix = null;

        private TargetsNameContext() {
        }

        public String calcTargetReferenceText(String targetReferenceText) {
            if (!this.myPrefixes.isEmpty()) {
                InclusionKind kind = (InclusionKind)((Object)this.myPrefixes.getLast().getSecond());
                switch (kind) {
                    case IMPORT: {
                        return targetReferenceText;
                    }
                    case INCLUDE: {
                        return this.getFQPrefix() + targetReferenceText;
                    }
                }
            }
            return targetReferenceText;
        }

        @NotNull
        public InclusionKind getCurrentInclusionKind() {
            if (this.myPrefixes.isEmpty()) {
                InclusionKind inclusionKind = InclusionKind.TOPLEVEL;
                if (inclusionKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/PropertyProviderFinder$TargetsNameContext", "getCurrentInclusionKind"));
                }
                return inclusionKind;
            }
            InclusionKind inclusionKind = (InclusionKind)((Object)this.myPrefixes.getLast().getSecond());
            if (inclusionKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/PropertyProviderFinder$TargetsNameContext", "getCurrentInclusionKind"));
            }
            return inclusionKind;
        }

        @NotNull
        public String getFQPrefix() {
            if (this.myCurrentPrefix != null) {
                String string = this.myCurrentPrefix;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/PropertyProviderFinder$TargetsNameContext", "getFQPrefix"));
                }
                return string;
            }
            if (this.myPrefixes.isEmpty()) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/PropertyProviderFinder$TargetsNameContext", "getFQPrefix"));
                }
                return "";
            }
            StringBuffer buf = new StringBuffer();
            for (Pair pair : this.myPrefixes) {
                buf.append((String)pair.getFirst());
            }
            this.myCurrentPrefix = buf.toString();
            if (this.myCurrentPrefix == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/PropertyProviderFinder$TargetsNameContext", "getFQPrefix"));
            }
            return this.myCurrentPrefix;
        }

        @NotNull
        public String getShortPrefix() {
            String string = this.myPrefixes.isEmpty() ? "" : (String)this.myPrefixes.getLast().getFirst();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/PropertyProviderFinder$TargetsNameContext", "getShortPrefix"));
            }
            return string;
        }

        public void pushPrefix(AntDomIncludingDirective directive, InclusionKind kind, @NotNull AntDomProject slaveProject) {
            if (slaveProject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slaveProject", "com/intellij/lang/ant/dom/PropertyProviderFinder$TargetsNameContext", "pushPrefix"));
            }
            String separator = directive.getTargetPrefixSeparatorValue();
            String prefix = directive.getTargetPrefix().getStringValue();
            if (prefix == null && (prefix = slaveProject.getName().getRawText()) == null) {
                prefix = "anonymous" + this.myDefaultPrefixCounter++;
            }
            this.pushPrefix(prefix.endsWith(separator) ? prefix : prefix + separator, kind);
        }

        public void pushPrefix(String prefix, InclusionKind kind) {
            this.myCurrentPrefix = null;
            this.myPrefixes.addLast((Pair<String, InclusionKind>)Pair.create((Object)prefix, (Object)((Object)kind)));
        }

        public void popPrefix() {
            this.myCurrentPrefix = null;
            this.myPrefixes.removeLast();
        }
    }

    private static enum InclusionKind {
        INCLUDE("included"),
        IMPORT("imported"),
        TOPLEVEL("toplevel");

        private final String myDisplayName;

        private InclusionKind(String displayName) {
            this.myDisplayName = displayName;
        }

        public String toString() {
            return this.myDisplayName;
        }
    }

    public static enum Stage {
        RESOLVE_MAP_BUILDING_STAGE,
        TARGETS_WALKUP_STAGE;

    }
}

