/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl.artifacts;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.ChunkBuildExtension;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.taskdefs.Property;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.lang.ant.config.impl.artifacts.AntArtifactPostprocessingPropertiesProvider;
import com.intellij.lang.ant.config.impl.artifacts.AntArtifactPreProcessingPropertiesProvider;
import com.intellij.lang.ant.config.impl.artifacts.AntArtifactProperties;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class AntArtifactBuildExtension
extends ChunkBuildExtension {
    public void generateTasksForArtifact(Artifact artifact, boolean preprocessing, ArtifactAntGenerationContext context, CompositeGenerator generator) {
        ArtifactPropertiesProvider provider = preprocessing ? AntArtifactPreProcessingPropertiesProvider.getInstance() : AntArtifactPostprocessingPropertiesProvider.getInstance();
        AntArtifactProperties properties = (AntArtifactProperties)artifact.getProperties(provider);
        if (properties != null && properties.isEnabled()) {
            String path = VfsUtil.urlToPath((String)properties.getFileUrl());
            String fileName = PathUtil.getFileName((String)path);
            String dirPath = PathUtil.getParentPath((String)path);
            String relativePath = GenerationUtils.toRelativePath((String)dirPath, (File)BuildProperties.getProjectBaseDir((Project)context.getProject()), (String)BuildProperties.getProjectBaseDirProperty(), (GenerationOptions)context.getGenerationOptions());
            Tag ant = new Tag("ant", new Pair[]{Pair.create((Object)"antfile", (Object)fileName), Pair.create((Object)"target", (Object)properties.getTargetName()), Pair.create((Object)"dir", (Object)relativePath)});
            String outputPath = BuildProperties.propertyRef((String)context.getArtifactOutputProperty(artifact));
            ant.add((Generator)new Property("artifact.output.path", outputPath));
            for (BuildFileProperty property : properties.getUserProperties()) {
                ant.add((Generator)new Property(property.getPropertyName(), property.getPropertyValue()));
            }
            generator.add((Generator)ant);
        }
    }

    @NotNull
    public String[] getTargets(ModuleChunk chunk) {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/impl/artifacts/AntArtifactBuildExtension", "getTargets"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public void process(Project project, ModuleChunk chunk, GenerationOptions genOptions, CompositeGenerator generator) {
    }
}

