/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.impl.AllJarsUnderDirEntry;
import com.intellij.lang.ant.config.impl.AntBuildFileClassLoaderHolder;
import com.intellij.lang.ant.config.impl.AntClasspathEntry;
import com.intellij.lang.ant.config.impl.AntInstallation;
import com.intellij.lang.ant.config.impl.AntReference;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.lang.ant.config.impl.ClassLoaderHolder;
import com.intellij.lang.ant.config.impl.CompositePropertyContainer;
import com.intellij.lang.ant.config.impl.GlobalAntConfiguration;
import com.intellij.lang.ant.config.impl.SinglePathEntry;
import com.intellij.lang.ant.config.impl.TargetFilter;
import com.intellij.lang.ant.dom.AntDomFileDescription;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.NewInstanceFactory;
import com.intellij.util.SystemProperties;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.ExternalizablePropertyContainer;
import com.intellij.util.config.IntProperty;
import com.intellij.util.config.ListProperty;
import com.intellij.util.config.StringProperty;
import com.intellij.util.config.ValueProperty;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntBuildFileImpl
implements AntBuildFileBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.config.impl.AntBuildFileImpl");
    @NonNls
    private static final String ANT_LIB = "/.ant/lib";
    private volatile Map<String, String> myCachedExternalProperties;
    private final Object myOptionsLock = new Object();
    public static final AbstractProperty<AntInstallation> ANT_INSTALLATION = new AbstractProperty<AntInstallation>(){

        public String getName() {
            return "$antInstallation";
        }

        public AntInstallation getDefault(AbstractProperty.AbstractPropertyContainer container) {
            return ((GlobalAntConfiguration)GlobalAntConfiguration.INSTANCE.get(container)).getBundledAnt();
        }

        public AntInstallation copy(AntInstallation value) {
            return value;
        }

        public AntInstallation get(AbstractProperty.AbstractPropertyContainer container) {
            if (container.hasProperty(ANT_REFERENCE)) {
                return (AntInstallation)RUN_WITH_ANT.get(container);
            }
            return ((GlobalAntConfiguration)GlobalAntConfiguration.INSTANCE.get(container)).getBundledAnt();
        }
    };
    public static final AbstractProperty<List<File>> ALL_CLASS_PATH = new AbstractProperty<List<File>>(){

        public String getName() {
            return "$allClasspath";
        }

        public List<File> getDefault(AbstractProperty.AbstractPropertyContainer container) {
            return this.get(container);
        }

        public List<File> get(AbstractProperty.AbstractPropertyContainer container) {
            ArrayList<File> classpath = new ArrayList<File>();
            this.collectClasspath(classpath, ADDITIONAL_CLASSPATH, container);
            AntInstallation antInstallation = (AntInstallation)ANT_INSTALLATION.get(container);
            if (antInstallation != null) {
                this.collectClasspath(classpath, AntInstallation.CLASS_PATH, antInstallation.getProperties());
            }
            return classpath;
        }

        private void collectClasspath(ArrayList<File> files, ListProperty<AntClasspathEntry> property, AbstractProperty.AbstractPropertyContainer container) {
            if (!container.hasProperty(property)) {
                return;
            }
            Iterator entries = property.getIterator(container);
            while (entries.hasNext()) {
                AntClasspathEntry entry = (AntClasspathEntry)entries.next();
                entry.addFilesTo(files);
            }
        }

        public void set(AbstractProperty.AbstractPropertyContainer container, List<File> files) {
            throw new UnsupportedOperationException(this.getName());
        }

        public List<File> copy(List<File> files) {
            return files;
        }
    };
    public static final BooleanProperty RUN_IN_BACKGROUND = new BooleanProperty("runInBackground", true);
    public static final IntProperty MAX_HEAP_SIZE = new IntProperty("maximumHeapSize", 128);
    public static final IntProperty MAX_STACK_SIZE = new IntProperty("maximumStackSize", 2);
    public static final BooleanProperty VERBOSE = new BooleanProperty("verbose", true);
    public static final BooleanProperty TREE_VIEW = new BooleanProperty("treeView", true);
    public static final BooleanProperty CLOSE_ON_NO_ERRORS = new BooleanProperty("viewClosedWhenNoErrors", false);
    public static final StringProperty CUSTOM_JDK_NAME = new StringProperty("customJdkName", "");
    public static final ListProperty<TargetFilter> TARGET_FILTERS = ListProperty.create((String)"targetFilters");
    public static final ListProperty<BuildFileProperty> ANT_PROPERTIES = ListProperty.create((String)"properties");
    public static final StringProperty ANT_COMMAND_LINE_PARAMETERS = new StringProperty("antCommandLine", "");
    public static final AbstractProperty<AntReference> ANT_REFERENCE = new ValueProperty("antReference", (Object)AntReference.PROJECT_DEFAULT);
    public static final ListProperty<AntClasspathEntry> ADDITIONAL_CLASSPATH = ListProperty.create((String)"additionalClassPath");
    public static final AbstractProperty<AntInstallation> RUN_WITH_ANT = new AbstractProperty<AntInstallation>(){

        public String getName() {
            return "$runWithAnt";
        }

        @Nullable
        public AntInstallation getDefault(AbstractProperty.AbstractPropertyContainer container) {
            return this.get(container);
        }

        @Nullable
        public AntInstallation get(AbstractProperty.AbstractPropertyContainer container) {
            return AntReference.findAnt(ANT_REFERENCE, container);
        }

        public AntInstallation copy(AntInstallation antInstallation) {
            return antInstallation;
        }
    };
    private final VirtualFile myVFile;
    private final Project myProject;
    private final AntConfigurationBase myAntConfiguration;
    private final ExternalizablePropertyContainer myWorkspaceOptions;
    private final ExternalizablePropertyContainer myProjectOptions;
    private final AbstractProperty.AbstractPropertyContainer myAllOptions;
    private final ClassLoaderHolder myClassloaderHolder;
    private boolean myShouldExpand = true;

    public AntBuildFileImpl(XmlFile antFile, AntConfigurationBase configuration) {
        this.myVFile = antFile.getOriginalFile().getVirtualFile();
        this.myProject = antFile.getProject();
        this.myAntConfiguration = configuration;
        this.myWorkspaceOptions = new ExternalizablePropertyContainer();
        this.myWorkspaceOptions.registerProperty(RUN_IN_BACKGROUND);
        this.myWorkspaceOptions.registerProperty(CLOSE_ON_NO_ERRORS);
        this.myWorkspaceOptions.registerProperty(TREE_VIEW);
        this.myWorkspaceOptions.registerProperty(VERBOSE);
        this.myWorkspaceOptions.registerProperty(TARGET_FILTERS, "filter", NewInstanceFactory.fromClass(TargetFilter.class));
        this.myWorkspaceOptions.rememberKey(RUN_WITH_ANT);
        this.myProjectOptions = new ExternalizablePropertyContainer();
        this.myProjectOptions.registerProperty(MAX_HEAP_SIZE);
        this.myProjectOptions.registerProperty(MAX_STACK_SIZE);
        this.myProjectOptions.registerProperty(CUSTOM_JDK_NAME);
        this.myProjectOptions.registerProperty(ANT_COMMAND_LINE_PARAMETERS);
        this.myProjectOptions.registerProperty(ANT_PROPERTIES, "property", NewInstanceFactory.fromClass(BuildFileProperty.class));
        this.myProjectOptions.registerProperty(ADDITIONAL_CLASSPATH, "entry", SinglePathEntry.EXTERNALIZER);
        this.myProjectOptions.registerProperty(ANT_REFERENCE, AntReference.EXTERNALIZER);
        this.myAllOptions = new CompositePropertyContainer(new AbstractProperty.AbstractPropertyContainer[]{this.myWorkspaceOptions, this.myProjectOptions, GlobalAntConfiguration.getInstance().getProperties(), configuration.getProperties()});
        this.myClassloaderHolder = new AntBuildFileClassLoaderHolder(this.myAllOptions);
    }

    public static List<File> getUserHomeLibraries() {
        ArrayList<File> classpath = new ArrayList<File>();
        String homeDir = SystemProperties.getUserHome();
        new AllJarsUnderDirEntry(new File(homeDir, ANT_LIB)).addFilesTo(classpath);
        return classpath;
    }

    @Override
    @Nullable
    public String getPresentableName() {
        String name;
        AntBuildModelBase model = this.myAntConfiguration.getModelIfRegistered(this);
        String string = name = model != null ? model.getName() : null;
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            name = this.myVFile.getName();
        }
        return name;
    }

    @Override
    @Nullable
    public String getName() {
        VirtualFile vFile = this.getVirtualFile();
        return vFile != null ? vFile.getName() : null;
    }

    @Override
    public AntBuildModelBase getModel() {
        return (AntBuildModelBase)this.myAntConfiguration.getModel(this);
    }

    @Override
    @Nullable
    public AntBuildModelBase getModelIfRegistered() {
        return this.myAntConfiguration.getModelIfRegistered(this);
    }

    @Override
    public boolean isRunInBackground() {
        return RUN_IN_BACKGROUND.value(this.myAllOptions);
    }

    @Override
    @Nullable
    public XmlFile getAntFile() {
        PsiFile psiFile;
        PsiFile psiFile2 = psiFile = this.myVFile.isValid() ? PsiManager.getInstance((Project)this.getProject()).findFile(this.myVFile) : null;
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        return AntDomFileDescription.isAntFile(xmlFile) ? xmlFile : null;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myVFile;
    }

    @Override
    public AbstractProperty.AbstractPropertyContainer getAllOptions() {
        return this.myAllOptions;
    }

    @Override
    @Nullable
    public String getPresentableUrl() {
        VirtualFile file = this.getVirtualFile();
        return file == null ? null : file.getPresentableUrl();
    }

    @Override
    public boolean shouldExpand() {
        return this.myShouldExpand;
    }

    @Override
    public void setShouldExpand(boolean expand) {
        this.myShouldExpand = expand;
    }

    @Override
    public boolean isTargetVisible(AntBuildTarget target) {
        TargetFilter filter = this.findFilter(target.getName());
        if (filter == null) {
            return target.isDefault() || target.getNotEmptyDescription() != null;
        }
        return filter.isVisible();
    }

    @Override
    public boolean exists() {
        VirtualFile file = this.getVirtualFile();
        return file != null && new File(file.getPath()).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateProperties() {
        AntBuildTarget[] targets = this.getModel().getTargets();
        LinkedHashMap<String, AntBuildTarget> targetByName = new LinkedHashMap<String, AntBuildTarget>(targets.length);
        for (AntBuildTarget target : targets) {
            String targetName = target.getName();
            if (targetName == null) continue;
            targetByName.put(targetName, target);
        }
        Object object = this.myOptionsLock;
        synchronized (object) {
            this.myCachedExternalProperties = null;
            ArrayList filters = TARGET_FILTERS.getModifiableList(this.myAllOptions);
            Iterator iterator = filters.iterator();
            while (iterator.hasNext()) {
                TargetFilter filter = (TargetFilter)iterator.next();
                String name = filter.getTargetName();
                if (name == null) {
                    iterator.remove();
                    continue;
                }
                AntBuildTarget target = (AntBuildTarget)targetByName.get(name);
                if (target != null) {
                    filter.updateDescription(target);
                    targetByName.remove(name);
                    continue;
                }
                iterator.remove();
            }
            for (AntBuildTarget target : targetByName.values()) {
                filters.add(TargetFilter.fromTarget(target));
            }
        }
    }

    @Override
    public void updateConfig() {
        this.basicUpdateConfig();
        DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart();
    }

    @Override
    public void setTreeView(boolean value) {
        TREE_VIEW.primSet(this.myAllOptions, value);
    }

    @Override
    public void setVerboseMode(boolean value) {
        VERBOSE.primSet(this.myAllOptions, value);
    }

    @Override
    public boolean isViewClosedWhenNoErrors() {
        return CLOSE_ON_NO_ERRORS.value(this.myAllOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readWorkspaceProperties(Element parentNode) throws InvalidDataException {
        Object object = this.myOptionsLock;
        synchronized (object) {
            Element antCommandLine;
            this.myWorkspaceOptions.readExternal(parentNode);
            Element expanded = parentNode.getChild("expanded");
            if (expanded != null) {
                this.myShouldExpand = Boolean.valueOf(expanded.getAttributeValue("value"));
            }
            if ((antCommandLine = parentNode.getChild("antCommandLine")) != null) {
                ANT_COMMAND_LINE_PARAMETERS.set((AbstractProperty.AbstractPropertyContainer)this.myProjectOptions, (Object)antCommandLine.getAttributeValue("value"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeWorkspaceProperties(Element parentNode) throws WriteExternalException {
        Object object = this.myOptionsLock;
        synchronized (object) {
            this.myWorkspaceOptions.writeExternal(parentNode);
            Element expandedElem = new Element("expanded");
            expandedElem.setAttribute("value", Boolean.toString(this.myShouldExpand));
            parentNode.addContent(expandedElem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readProperties(Element parentNode) throws InvalidDataException {
        Object object = this.myOptionsLock;
        synchronized (object) {
            this.myProjectOptions.readExternal(parentNode);
            this.basicUpdateConfig();
            this.readWorkspaceProperties(parentNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeProperties(Element parentNode) throws WriteExternalException {
        Object object = this.myOptionsLock;
        synchronized (object) {
            this.myProjectOptions.writeExternal(parentNode);
        }
    }

    private void basicUpdateConfig() {
        XmlFile antFile = this.getAntFile();
        if (antFile != null) {
            this.bindAnt();
            this.myClassloaderHolder.updateClasspath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Map<String, String> getExternalProperties() {
        HashMap result = this.myCachedExternalProperties;
        if (result == null) {
            Object object = this.myOptionsLock;
            synchronized (object) {
                result = this.myCachedExternalProperties;
                if (result == null) {
                    result = new HashMap();
                    DataContext context = SimpleDataContext.getProjectContext((Project)this.myProject);
                    MacroManager macroManager = MacroManager.getInstance();
                    Iterator properties = ANT_PROPERTIES.getIterator(this.myAllOptions);
                    while (properties.hasNext()) {
                        BuildFileProperty property = (BuildFileProperty)properties.next();
                        try {
                            String value = property.getPropertyValue();
                            value = macroManager.expandSilentMarcos(value, true, context);
                            value = macroManager.expandSilentMarcos(value, false, context);
                            result.put(property.getPropertyName(), value);
                        }
                        catch (Macro.ExecutionCancelledException e) {
                            LOG.debug((Throwable)e);
                        }
                    }
                    this.myCachedExternalProperties = result;
                }
            }
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/impl/AntBuildFileImpl", "getExternalProperties"));
        }
        return hashMap;
    }

    private void bindAnt() {
        ANT_REFERENCE.set(this.getAllOptions(), (Object)((AntReference)ANT_REFERENCE.get(this.getAllOptions())).bind(GlobalAntConfiguration.getInstance()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private TargetFilter findFilter(String targetName) {
        List filters;
        Iterator iterator = this.myOptionsLock;
        synchronized (iterator) {
            filters = (List)TARGET_FILTERS.get(this.myAllOptions);
        }
        for (TargetFilter targetFilter : filters) {
            if (!Comparing.equal((String)targetName, (String)targetFilter.getTargetName())) continue;
            return targetFilter;
        }
        return null;
    }

    @NotNull
    public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.myClassloaderHolder.getClassloader();
        if (classLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/impl/AntBuildFileImpl", "getClassLoader"));
        }
        return classLoader;
    }
}

