/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.timeTracking;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.timeTracking.TasksToolWindowFactory;
import com.intellij.tasks.timeTracking.model.WorkItem;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

@State(name="TimeTrackingManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class TimeTrackingManager
implements Disposable,
PersistentStateComponent<Config> {
    private static final int TIME_TRACKING_TIME_UNIT = 1000;
    private final Project myProject;
    private final TaskManager myTaskManager;
    private final Config myConfig;
    private Timer myTimeTrackingTimer;
    private final Alarm myIdleAlarm;
    private Runnable myActivityListener;
    private LocalTask myLastActiveTask;

    public TimeTrackingManager(@NotNull Project project, @NotNull TaskManager taskManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/timeTracking/TimeTrackingManager", "<init>"));
        }
        if (taskManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskManager", "com/intellij/tasks/timeTracking/TimeTrackingManager", "<init>"));
        }
        this.myConfig = new Config();
        this.myIdleAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.myProject = project;
        this.myTaskManager = taskManager;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.myTimeTrackingTimer = UIUtil.createNamedTimer((String)"TaskManager time tracking", (int)1000, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocalTask activeTask = TimeTrackingManager.this.myTaskManager.getActiveTask();
                if (TimeTrackingManager.this.myLastActiveTask != activeTask) {
                    activeTask.addWorkItem(new WorkItem(new Date()));
                }
                if (TimeTrackingManager.this.getState().autoMode) {
                    WorkItem lastWorkItem = (WorkItem)activeTask.getWorkItems().get(activeTask.getWorkItems().size() - 1);
                    lastWorkItem.duration += 1000L;
                    TimeTrackingManager.this.getState().totallyTimeSpent += 1000L;
                } else if (activeTask.isRunning()) {
                    WorkItem lastWorkItem = (WorkItem)activeTask.getWorkItems().get(activeTask.getWorkItems().size() - 1);
                    lastWorkItem.duration += 1000L;
                    TimeTrackingManager.this.getState().totallyTimeSpent += 1000L;
                }
                TimeTrackingManager.this.myLastActiveTask = activeTask;
            }
        });
        this.myActivityListener = () -> {
            IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
            if (frame == null) {
                return;
            }
            Project project1 = frame.getProject();
            if (project1 == null || !this.myProject.equals(project1)) {
                return;
            }
            this.startTimeTrackingTimer();
        };
        if (this.getState().autoMode) {
            IdeEventQueue.getInstance().addActivityListener(this.myActivityListener, (Disposable)this.myProject);
        }
    }

    public static TimeTrackingManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/timeTracking/TimeTrackingManager", "getInstance"));
        }
        return (TimeTrackingManager)ServiceManager.getService((Project)project, TimeTrackingManager.class);
    }

    private void startTimeTrackingTimer() {
        if (this.myIdleAlarm.isDisposed()) {
            return;
        }
        if (!this.myTimeTrackingTimer.isRunning()) {
            this.myTimeTrackingTimer.start();
        }
        this.myIdleAlarm.cancelAllRequests();
        this.myIdleAlarm.addRequest(() -> {
            if (this.myTimeTrackingTimer.isRunning()) {
                this.myTimeTrackingTimer.stop();
            }
        }, this.getState().suspendDelayInSeconds * 1000);
    }

    public void updateTimeTrackingToolWindow() {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.TASKS);
        if (this.isTimeTrackingToolWindowAvailable()) {
            if (toolWindow == null) {
                toolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(ToolWindowId.TASKS, true, ToolWindowAnchor.RIGHT, (Disposable)this.myProject, true);
                new TasksToolWindowFactory().createToolWindowContent(this.myProject, toolWindow);
            }
            ToolWindow finalToolWindow = toolWindow;
            ApplicationManager.getApplication().invokeLater(() -> {
                finalToolWindow.setAvailable(true, null);
                finalToolWindow.show(null);
                finalToolWindow.activate(null);
            });
        } else if (toolWindow != null) {
            ToolWindow finalToolWindow = toolWindow;
            ApplicationManager.getApplication().invokeLater(() -> finalToolWindow.setAvailable(false, null));
        }
    }

    public boolean isTimeTrackingToolWindowAvailable() {
        return this.getState().enabled;
    }

    public void setAutoMode(boolean on) {
        boolean oldState = this.getState().autoMode;
        if (on != oldState) {
            this.getState().autoMode = on;
            if (on) {
                IdeEventQueue.getInstance().addActivityListener(this.myActivityListener, (Disposable)this.myProject);
            } else {
                IdeEventQueue.getInstance().removeActivityListener(this.myActivityListener);
                this.myIdleAlarm.cancelAllRequests();
                if (!this.myTimeTrackingTimer.isRunning()) {
                    this.myTimeTrackingTimer.start();
                }
            }
        }
    }

    public void dispose() {
        if (this.myTimeTrackingTimer != null) {
            this.myTimeTrackingTimer.stop();
        }
    }

    @NotNull
    public Config getState() {
        Config config = this.myConfig;
        if (config == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/timeTracking/TimeTrackingManager", "getState"));
        }
        return config;
    }

    public void loadState(Config state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myConfig);
    }

    public static class Config {
        public boolean enabled = false;
        public long totallyTimeSpent = 0L;
        public int suspendDelayInSeconds = 600;
        public boolean autoMode = true;
        public boolean showClosedTasks = true;
        public boolean showSpentTimeFromLastPost = false;
    }

    private static final class TimeTrackingStartupActivity
    implements StartupActivity,
    DumbAware {
        private TimeTrackingStartupActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/timeTracking/TimeTrackingManager$TimeTrackingStartupActivity", "runActivity"));
            }
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode()) {
                return;
            }
            app.invokeLater(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/timeTracking/TimeTrackingManager$TimeTrackingStartupActivity", "lambda$runActivity$0"));
                }
                TimeTrackingManager.getInstance(project).startTimeTrackingTimer();
            }, project.getDisposed());
        }
    }
}

