/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanNamesReferenceProvider
extends PsiReferenceProvider {
    public static final String[] METHODS = new String[]{"containsBean", "getBean", "isSingleton", "getType", "getAliases"};

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiLiteral literalExpression;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/references/SpringBeanNamesReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/references/SpringBeanNamesReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof PsiLiteral && (literalExpression = (PsiLiteral)element).getValue() instanceof String) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new SpringBeanReference((PsiElement)literalExpression, ElementManipulators.getManipulator((PsiElement)element).getRangeInElement(element), SpringBeanNamesReferenceProvider.determineRequiredClass(element), false)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringBeanNamesReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringBeanNamesReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Nullable
    public static PsiClass determineRequiredClass(PsiElement element) {
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class);
        if (expression == null) {
            return null;
        }
        ExpectedTypeInfo[] types = ExpectedTypesProvider.getExpectedTypes((PsiExpression)expression, (boolean)true);
        if (types.length != 1) {
            return null;
        }
        PsiType type = types[0].getType();
        return PsiTypesUtil.getPsiClass((PsiType)type);
    }
}

