/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.profiles.SpringProfile;
import com.intellij.spring.profiles.SpringProfilesFactory;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringProfilePsiReference
extends PsiReferenceBase<PsiElement> {
    private final String myProfileName;
    private final Module myModule;
    private final boolean myIsDefinition;

    public SpringProfilePsiReference(@NotNull PsiElement element, @NotNull TextRange range, @NotNull Module module, boolean definition) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/profiles/SpringProfilePsiReference", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spring/profiles/SpringProfilePsiReference", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/profiles/SpringProfilePsiReference", "<init>"));
        }
        super(element, range);
        this.myIsDefinition = definition;
        this.myProfileName = range.substring(element.getText());
        this.myModule = module;
    }

    public PsiElement resolve() {
        if (StringUtil.isEmptyOrSpaces((String)this.myProfileName)) {
            return this.myElement;
        }
        SpringProfilesFactory profilesFactory = SpringProfilesFactory.getInstance(this.myModule);
        if (this.myIsDefinition) {
            return profilesFactory.getOrCreateProfile(this.myProfileName, this.getElement());
        }
        return profilesFactory.findProfile(this.myProfileName);
    }

    public boolean isSoft() {
        return true;
    }

    @NotNull
    public Object[] getVariants() {
        Set<SpringProfile> profiles = SpringProfilesFactory.getInstance(this.myModule).getProfiles();
        SpringProfile[] springProfileArray = profiles.toArray(new SpringProfile[profiles.size()]);
        if (springProfileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/profiles/SpringProfilePsiReference", "getVariants"));
        }
        return springProfileArray;
    }
}

