/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml;

import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.DefaultSpringBeanQualifier;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.xml.AbstractDomSpringBean;
import com.intellij.spring.model.xml.BeanName;
import com.intellij.spring.model.xml.BeanNameProvider;
import com.intellij.spring.model.xml.BeanProviderRegistry;
import com.intellij.spring.model.xml.BeanType;
import com.intellij.spring.model.xml.BeanTypeProvider;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.DomUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomSpringBeanImpl
extends AbstractDomSpringBean
implements DomSpringBean {
    private static final Map<Class, BeanName> ourBeanNameCache = new ConcurrentFactoryMap<Class, BeanName>(){

        @Nullable
        protected BeanName create(Class key) {
            return (BeanName)DomReflectionUtil.findAnnotationDFS((Class)key, BeanName.class);
        }
    };
    private static final Map<Class, BeanType> ourBeanTypeCache = new ConcurrentFactoryMap<Class, BeanType>(){

        @Nullable
        protected BeanType create(Class key) {
            return (BeanType)DomReflectionUtil.findAnnotationDFS((Class)key, BeanType.class);
        }
    };

    @Override
    @Nullable
    public String getBeanName() {
        BeanName beanName = ourBeanNameCache.get(this.getClass());
        if (beanName == null) {
            return DomUtil.hasXml((DomElement)this.getId()) ? this.getId().getRawText() : null;
        }
        String value = beanName.value();
        if (!value.isEmpty()) {
            return value;
        }
        Class<? extends BeanNameProvider> providerClass = beanName.provider();
        if (providerClass == BeanNameProvider.class) {
            throw new IllegalStateException("@BeanName: no value() given, provider() must be set" + this.getDomElementType());
        }
        BeanNameProvider beanNameProvider = BeanProviderRegistry.getInstance().getBeanNameProvider(providerClass);
        return beanNameProvider.getBeanName(this);
    }

    @Override
    public void setName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/spring/model/xml/DomSpringBeanImpl", "setName"));
        }
        if (DomUtil.hasXml((DomElement)this.getId())) {
            this.getId().setStringValue(newName);
        }
    }

    @Override
    @Nullable
    public final String getClassName() {
        BeanType beanType = ourBeanTypeCache.get(this.getClass());
        if (beanType == null) {
            return null;
        }
        String value = beanType.value();
        if (!value.isEmpty()) {
            return value;
        }
        Class<? extends BeanTypeProvider> providerClass = beanType.provider();
        if (providerClass == BeanTypeProvider.class) {
            throw new IllegalStateException("@BeanType: no value() given, provider() must be set" + this.getDomElementType());
        }
        BeanTypeProvider beanTypeProvider = BeanProviderRegistry.getInstance().getBeanTypeProvider(providerClass);
        return beanTypeProvider.getBeanType(this);
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        XmlFile xmlFile = DomUtil.getFile((DomElement)this);
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/DomSpringBeanImpl", "getContainingFile"));
        }
        return xmlFile;
    }

    @Nullable
    public PsiElement getIdentifyingPsiElement() {
        if (!this.isValid()) {
            return null;
        }
        return PomService.convertToPsi((Project)this.getManager().getProject(), (PomTarget)BeanService.getInstance().createSpringBeanPsiTarget(this));
    }

    @Override
    @NotNull
    public String[] getAliases() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/DomSpringBeanImpl", "getAliases"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.getManager().getProject());
    }

    @Override
    public Beans getBeansParent() {
        return (Beans)DomUtil.getParentOfType((DomElement)this, Beans.class, (boolean)false);
    }

    @Override
    public SpringQualifier getSpringQualifier() {
        return DefaultSpringBeanQualifier.create(this);
    }
}

