/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values.converters.resources;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import org.jetbrains.annotations.NotNull;

public class ResourceTypeCondition
implements Condition<PsiFileSystemItem> {
    private final String[] myFileExtensions;

    public ResourceTypeCondition(String ... fileExtensions) {
        if (fileExtensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileExtensions", "com/intellij/spring/model/values/converters/resources/ResourceTypeCondition", "<init>"));
        }
        this.myFileExtensions = fileExtensions;
    }

    public boolean value(PsiFileSystemItem psiFileSystemItem) {
        for (String fileExtension : this.myFileExtensions) {
            if (!ResourceTypeCondition.hasExtension(psiFileSystemItem, fileExtension)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasExtension(PsiFileSystemItem psiFileSystemItem, String fileExtension) {
        if (FileReferenceSet.DIRECTORY_FILTER.value((Object)psiFileSystemItem)) {
            return true;
        }
        VirtualFile virtualFile = psiFileSystemItem.getVirtualFile();
        return virtualFile != null && fileExtension.equals(virtualFile.getExtension());
    }

    @NotNull
    public String[] getExpectedExtensions() {
        if (this.myFileExtensions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/converters/resources/ResourceTypeCondition", "getExpectedExtensions"));
        }
        return this.myFileExtensions;
    }
}

