/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.pom;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanPomTargetUtils {
    private SpringBeanPomTargetUtils() {
    }

    @Nullable
    public static CommonSpringBean getSpringBean(PsiElement element) {
        if (!(element instanceof PomTargetPsiElement)) {
            return null;
        }
        PomTargetPsiElement pomTargetPsiElement = (PomTargetPsiElement)element;
        PomTarget target = pomTargetPsiElement.getTarget();
        if (!target.isValid()) {
            return null;
        }
        return SpringBeanPomTargetUtils.getSpringBean(target);
    }

    @Nullable
    public static CommonSpringBean getSpringBean(@NotNull PomTarget target) {
        JamElement jamElement;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/spring/model/pom/SpringBeanPomTargetUtils", "getSpringBean"));
        }
        if (target instanceof AliasingPsiTarget) {
            PsiElement navigationElement = ((AliasingPsiTarget)target).getNavigationElement();
            if (!(navigationElement instanceof PsiClass)) {
                return null;
            }
            SpringStereotypeElement stereotypeElement = SpringJamUtils.getInstance().findStereotypeElement((PsiClass)navigationElement);
            if (stereotypeElement != null && stereotypeElement.getPsiTarget() instanceof AliasingPsiTarget) {
                return stereotypeElement;
            }
            return null;
        }
        if (target instanceof SpringBeanPsiTarget) {
            return ((SpringBeanPsiTarget)target).getSpringBean();
        }
        if (target instanceof JamPomTarget && (jamElement = ((JamPomTarget)target).getJamElement()) instanceof JamPsiMemberSpringBean) {
            return (JamPsiMemberSpringBean)jamElement;
        }
        return null;
    }
}

