/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils.filters;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringContextFilter {

    public static abstract class IncludeClasses
    extends Include {
        private final Collection<PsiClass> myClasses;

        protected IncludeClasses(@NotNull Collection<PsiClass> classes) {
            if (classes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/spring/model/jam/utils/filters/SpringContextFilter$IncludeClasses", "<init>"));
            }
            this.myClasses = classes;
        }

        public Collection<PsiClass> getClasses() {
            return this.myClasses;
        }
    }

    public static abstract class IncludeExpression
    extends Include {
        @Nullable
        private final String myExpression;

        protected IncludeExpression(@Nullable String expression) {
            this.myExpression = expression;
        }

        @Nullable
        public String getExpression() {
            return this.myExpression;
        }
    }

    public static abstract class Include
    extends SpringContextFilter {
        public static final Include EMPTY_INCLUDE = new Include(){

            @Override
            @NotNull
            public Set<SpringStereotypeElement> includeStereotypes(@NotNull Module module, @NotNull Set<PsiPackage> packages) {
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/utils/filters/SpringContextFilter$Include$1", "includeStereotypes"));
                }
                if (packages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/spring/model/jam/utils/filters/SpringContextFilter$Include$1", "includeStereotypes"));
                }
                Set<SpringStereotypeElement> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/filters/SpringContextFilter$Include$1", "includeStereotypes"));
                }
                return set;
            }
        };

        @NotNull
        public abstract Set<SpringStereotypeElement> includeStereotypes(@NotNull Module var1, @NotNull Set<PsiPackage> var2);
    }

    public static abstract class ExcludeClasses
    extends Exclude {
        private final Collection<PsiClass> myClasses;

        protected ExcludeClasses(@NotNull Collection<PsiClass> classes) {
            if (classes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/spring/model/jam/utils/filters/SpringContextFilter$ExcludeClasses", "<init>"));
            }
            this.myClasses = classes;
        }

        public Collection<PsiClass> getClasses() {
            return this.myClasses;
        }
    }

    public static abstract class ExcludeExpression
    extends Exclude {
        @Nullable
        private final String myExpression;

        protected ExcludeExpression(@Nullable String expression) {
            this.myExpression = expression;
        }

        @Nullable
        public String getExpression() {
            return this.myExpression;
        }
    }

    public static abstract class Exclude
    extends SpringContextFilter {
        public static final Exclude EMPTY_EXCLUDE = new Exclude(){

            @Override
            public boolean exclude(@NotNull PsiClass psiClass) {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/jam/utils/filters/SpringContextFilter$Exclude$1", "exclude"));
                }
                return false;
            }
        };

        public abstract boolean exclude(@NotNull PsiClass var1);
    }
}

