/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.converters.SpringBeanResolveConverter;
import com.intellij.util.SmartList;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBeanResolveConverterForDefiniteClasses
extends SpringBeanResolveConverter {
    @Nullable
    protected abstract String[] getClassNames(ConvertContext var1);

    @Override
    @NotNull
    public List<PsiClassType> getRequiredClasses(ConvertContext context) {
        String[] classNames = this.getClassNames(context);
        if (classNames == null || classNames.length == 0) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanResolveConverterForDefiniteClasses", "getRequiredClasses"));
            }
            return list;
        }
        SmartList required = new SmartList();
        for (String className : classNames) {
            PsiClass psiClass = DomJavaUtil.findClass((String)className, (DomElement)context.getInvocationElement());
            if (psiClass == null) continue;
            required.add(PsiTypesUtil.getClassType((PsiClass)psiClass));
        }
        SmartList smartList = required;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanResolveConverterForDefiniteClasses", "getRequiredClasses"));
        }
        return smartList;
    }
}

