/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.spring.SpringApiBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiMethodConverter
extends Converter<PsiMethod>
implements CustomReferenceConverter<PsiMethod> {
    private final MethodAccepter myMethodAccepter;

    protected PsiMethodConverter(MethodAccepter accepter) {
        this.myMethodAccepter = accepter;
    }

    protected PsiMethodConverter() {
        this(new MethodAccepter());
    }

    public PsiMethod fromString(@Nullable String methodName, ConvertContext context) {
        if (StringUtil.isEmpty((String)methodName)) {
            return null;
        }
        PsiClass psiClass = this.getPsiClass(context);
        if (psiClass == null) {
            return null;
        }
        PsiMethod[] psiMethods = this.getMethodCandidates(methodName, psiClass);
        if (psiMethods.length == 0) {
            return null;
        }
        MethodAccepter accepter = this.getMethodAccepter(context, false);
        for (PsiMethod method : psiMethods) {
            if (!accepter.accept(method)) continue;
            return method;
        }
        return null;
    }

    protected abstract PsiMethod[] getMethodCandidates(String var1, PsiClass var2);

    public String toString(@Nullable PsiMethod psiMethods, ConvertContext context) {
        return null;
    }

    @Nullable
    protected abstract PsiClass getPsiClass(ConvertContext var1);

    protected MethodAccepter getMethodAccepter(ConvertContext context, boolean forCompletion) {
        return this.myMethodAccepter;
    }

    protected Object[] getVariants(ConvertContext context) {
        PsiClass psiClass = this.getPsiClass(context);
        if (psiClass == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        MethodAccepter methodAccepter = this.getMethodAccepter(context, true);
        ArrayList<LookupElementBuilder> result = new ArrayList<LookupElementBuilder>();
        Collection allMethodSigs = psiClass.getVisibleSignatures();
        for (HierarchicalMethodSignature signature : allMethodSigs) {
            PsiMethod method = signature.getMethod();
            if (!methodAccepter.accept(method)) continue;
            String tail = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)256, (int)3);
            LookupElementBuilder builder = LookupElementBuilder.create((Object)method, (String)this.getMethodIdentificator(method)).withIcon(method.getIcon(0)).withStrikeoutness(method.isDeprecated()).withTailText(tail);
            PsiType returnType = method.getReturnType();
            if (returnType != null) {
                builder = builder.withTypeText(returnType.getPresentableText());
            }
            result.add(builder);
        }
        return ArrayUtil.toObjectArray(result);
    }

    protected abstract String getMethodIdentificator(PsiMethod var1);

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiMethod> genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray = new PsiReference[]{new MyReference(element, genericDomValue, context)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/PsiMethodConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    protected LocalQuickFix[] getQuickFixes(ConvertContext context) {
        return LocalQuickFix.EMPTY_ARRAY;
    }

    protected class MyReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider,
    LocalQuickFixProvider {
        private final GenericDomValue<PsiMethod> myGenericDomValue;
        private final ConvertContext myContext;

        public MyReference(PsiElement element, GenericDomValue<PsiMethod> genericDomValue, ConvertContext context) {
            super(element);
            this.myGenericDomValue = genericDomValue;
            this.myContext = context;
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = PsiMethodConverter.this.getVariants(this.myContext);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/PsiMethodConverter$MyReference", "getVariants"));
            }
            return objectArray;
        }

        @Nullable
        public PsiElement resolve() {
            return (PsiElement)this.myGenericDomValue.getValue();
        }

        public boolean isSoft() {
            return true;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/converters/PsiMethodConverter$MyReference", "bindToElement"));
            }
            if (!(element instanceof PsiMethod)) {
                throw new IncorrectOperationException("PsiMethod expected, but found: " + element);
            }
            PsiMethod psiMethod = (PsiMethod)element;
            this.myGenericDomValue.setStringValue(PsiMethodConverter.this.getMethodIdentificator(psiMethod));
            return psiMethod;
        }

        public LocalQuickFix[] getQuickFixes() {
            return PsiMethodConverter.this.getQuickFixes(this.myContext);
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = SpringApiBundle.message("cannot.resolve.method", this.myGenericDomValue.getStringValue());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/PsiMethodConverter$MyReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }
    }

    protected static class MethodAccepter {
        protected MethodAccepter() {
        }

        public boolean accept(PsiMethod method) {
            return !method.isConstructor() && method.hasModifierProperty("public") && !method.hasModifierProperty("static");
        }
    }
}

