/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.converters.SpringBeanResolveConverter;
import com.intellij.spring.model.xml.beans.LookupMethod;
import com.intellij.util.xml.ConvertContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LookupMethodBeanConverter
extends SpringBeanResolveConverter {
    @Override
    @NotNull
    public List<PsiClassType> getRequiredClasses(ConvertContext context) {
        PsiType returnType;
        LookupMethod lookupMethod = (LookupMethod)context.getInvocationElement().getParent();
        assert (lookupMethod != null);
        PsiMethod psiMethod = (PsiMethod)lookupMethod.getName().getValue();
        if (psiMethod != null && (returnType = psiMethod.getReturnType()) instanceof PsiClassType) {
            List<PsiClassType> list = Collections.singletonList((PsiClassType)returnType);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/LookupMethodBeanConverter", "getRequiredClasses"));
            }
            return list;
        }
        List<PsiClassType> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/LookupMethodBeanConverter", "getRequiredClasses"));
        }
        return list;
    }
}

