/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns.frameworks;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.actions.patterns.frameworks.FrameworkIntegrationAction;
import com.intellij.spring.model.actions.patterns.frameworks.FrameworkSupportTemplatesRunner;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFrameworkIntegrationAction
extends FrameworkIntegrationAction {
    @Override
    protected void generateSpringBeans(Module module, Editor editor, XmlFile xmlFile) {
        FrameworkSupportTemplatesRunner.getInstance().generateSpringBeans(this, module, editor, xmlFile);
    }

    @Override
    @NotNull
    public Map<String, String> getPredefinedVars(@NotNull Module module, XmlFile xmlFile) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/actions/patterns/frameworks/AbstractFrameworkIntegrationAction", "getPredefinedVars"));
        }
        Map<String, String> map = FrameworkSupportTemplatesRunner.getInstance().getPredefinedVars(module, xmlFile);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/actions/patterns/frameworks/AbstractFrameworkIntegrationAction", "getPredefinedVars"));
        }
        return map;
    }

    @Override
    public void addFacet(Module module) {
        if (module == null) {
            return;
        }
        String facetId = this.getFacetId();
        if (!StringUtil.isEmptyOrSpaces((String)facetId)) {
            FacetManager facetManager = FacetManager.getInstance((Module)module);
            FacetType type = FacetTypeRegistry.getInstance().findFacetType(facetId);
            if (type != null && facetManager.getFacetByType(type.getId()) == null) {
                ModifiableFacetModel model = facetManager.createModifiableModel();
                Facet facet = facetManager.addFacet(type, type.getDefaultFacetName(), null);
                model.addFacet(facet);
                model.commit();
            }
        }
    }

    @Nullable
    protected String getFacetId() {
        return null;
    }
}

