/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringImplicitBean;
import com.intellij.spring.model.custom.CustomModuleComponentsDiscoverer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringImplicitBeansProviderBase
extends CustomModuleComponentsDiscoverer {
    protected abstract Collection<CommonSpringBean> getImplicitBeans(@NotNull Module var1);

    @Override
    @NotNull
    public final Collection<CommonSpringBean> getCustomComponents(@Nullable Module module) {
        if (module == null || module.isDisposed() || DumbService.isDumb((Project)module.getProject())) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/SpringImplicitBeansProviderBase", "getCustomComponents"));
            }
            return list;
        }
        Collection<CommonSpringBean> collection = this.getImplicitBeans(module);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/SpringImplicitBeansProviderBase", "getCustomComponents"));
        }
        return collection;
    }

    @Nullable
    protected static PsiClass findClassInDependenciesAndLibraries(@NotNull Module module, @NotNull String className) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/SpringImplicitBeansProviderBase", "findClassInDependenciesAndLibraries"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/spring/model/SpringImplicitBeansProviderBase", "findClassInDependenciesAndLibraries"));
        }
        if (module.isDisposed()) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        return facade.findClass(className, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false));
    }

    protected void addImplicitBean(@NotNull Collection<CommonSpringBean> implicitBeans, @NotNull Module module, @NotNull String className, @NotNull String beanName) {
        if (implicitBeans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implicitBeans", "com/intellij/spring/model/SpringImplicitBeansProviderBase", "addImplicitBean"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/SpringImplicitBeansProviderBase", "addImplicitBean"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/spring/model/SpringImplicitBeansProviderBase", "addImplicitBean"));
        }
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/model/SpringImplicitBeansProviderBase", "addImplicitBean"));
        }
        this.doAddImplicitBean(implicitBeans, module, className, beanName, false);
    }

    protected void addImplicitLibraryBean(@NotNull Collection<CommonSpringBean> implicitBeans, @NotNull Module module, @NotNull String className, @NotNull String beanName) {
        if (implicitBeans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implicitBeans", "com/intellij/spring/model/SpringImplicitBeansProviderBase", "addImplicitLibraryBean"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/SpringImplicitBeansProviderBase", "addImplicitLibraryBean"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/spring/model/SpringImplicitBeansProviderBase", "addImplicitLibraryBean"));
        }
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/model/SpringImplicitBeansProviderBase", "addImplicitLibraryBean"));
        }
        this.doAddImplicitBean(implicitBeans, module, className, beanName, true);
    }

    private void doAddImplicitBean(@NotNull Collection<CommonSpringBean> implicitBeans, @NotNull Module module, @NotNull String className, @NotNull String beanName, boolean isLibraryClass) {
        PsiClass psiClass;
        if (implicitBeans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implicitBeans", "com/intellij/spring/model/SpringImplicitBeansProviderBase", "doAddImplicitBean"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/SpringImplicitBeansProviderBase", "doAddImplicitBean"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/spring/model/SpringImplicitBeansProviderBase", "doAddImplicitBean"));
        }
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/model/SpringImplicitBeansProviderBase", "doAddImplicitBean"));
        }
        PsiClass psiClass2 = psiClass = isLibraryClass ? SpringCommonUtils.findLibraryClass(module, className) : SpringImplicitBeansProviderBase.findClassInDependenciesAndLibraries(module, className);
        if (psiClass != null) {
            implicitBeans.add(new SpringImplicitBean(this.getProviderName(), psiClass, beanName));
        }
    }

    @Override
    public Object[] getDependencies(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/SpringImplicitBeansProviderBase", "getDependencies"));
        }
        return SpringModificationTrackersManager.getInstance(module.getProject()).getOuterModelsDependencies();
    }
}

