/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSetData;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringFileSet
implements Disposable {
    private final SpringFileSetData myData;
    private final SpringFacet myFacet;
    private final List<VirtualFilePointer> myFiles = new SmartList();
    private boolean myAutodetected;

    protected SpringFileSet(String id, String name, SpringFacet parent) {
        this(SpringFileSetData.create(id, name), parent);
    }

    protected SpringFileSet(SpringFileSetData data, SpringFacet facet) {
        this.myData = data;
        this.myFacet = facet;
        for (String url : data.getFiles()) {
            this.myFiles.add(this.createVirtualFilePointer(url));
        }
    }

    protected SpringFileSet(SpringFileSet original) {
        this.myFacet = original.getFacet();
        this.myData = SpringFileSetData.create(original.getData());
        this.myFiles.addAll(original.getFiles());
        this.myAutodetected = original.isAutodetected();
        this.myData.setActiveProfiles(original.getActiveProfiles());
    }

    @NotNull
    public String getId() {
        String string = this.myData.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFileSet", "getId"));
        }
        return string;
    }

    public String getName() {
        return this.myData.getName();
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/facet/SpringFileSet", "setName"));
        }
        this.myData.setName(name);
    }

    public String getQualifiedName() {
        return SpringFileSetService.getInstance().getQualifiedName(this);
    }

    public abstract Icon getIcon();

    public boolean isNew() {
        return false;
    }

    public boolean isAutodetected() {
        return this.myAutodetected;
    }

    public void setAutodetected(boolean autodetected) {
        this.myAutodetected = autodetected;
    }

    public boolean isRemoved() {
        return this.myData.isRemoved();
    }

    void setRemoved(boolean removed) {
        this.myData.setRemoved(removed);
    }

    public SpringFacet getFacet() {
        return this.myFacet;
    }

    SpringFileSetData getData() {
        return this.myData;
    }

    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myData.getActiveProfiles();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFileSet", "getActiveProfiles"));
        }
        return set;
    }

    public void setActiveProfiles(@NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/facet/SpringFileSet", "setActiveProfiles"));
        }
        this.myData.setActiveProfiles(activeProfiles);
    }

    public Set<SpringFileSet> getDependencyFileSets() {
        LinkedHashSet sets = ContainerUtil.newLinkedHashSet();
        for (String dependencyId : this.myData.getDependencies()) {
            SpringFileSet fileSet = SpringFileSetService.getInstance().findDependencyFileSet(this, dependencyId);
            ContainerUtil.addIfNotNull((Collection)sets, (Object)fileSet);
        }
        return sets;
    }

    public void setDependencies(List<SpringFileSet> springFileSets) {
        this.myData.getDependencies().clear();
        for (SpringFileSet dependency : springFileSets) {
            this.addDependency(dependency);
        }
    }

    public void addDependency(@NotNull SpringFileSet springFileSet) {
        if (springFileSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springFileSet", "com/intellij/spring/facet/SpringFileSet", "addDependency"));
        }
        this.myData.addDependency(this.getDependencyIdFor(springFileSet));
    }

    public void removeDependency(@NotNull SpringFileSet springFileSet) {
        if (springFileSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springFileSet", "com/intellij/spring/facet/SpringFileSet", "removeDependency"));
        }
        this.myData.getDependencies().remove(this.getDependencyIdFor(springFileSet));
    }

    private String getDependencyIdFor(SpringFileSet other) {
        return SpringFileSetService.getInstance().getDependencyIdFor(this, other);
    }

    @NotNull
    public List<VirtualFilePointer> getFiles() {
        List<VirtualFilePointer> list = this.myFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFileSet", "getFiles"));
        }
        return list;
    }

    @NotNull
    public Set<VirtualFilePointer> getXmlFiles() {
        Set<VirtualFilePointer> set = this.getConfigFiles((FileType)StdFileTypes.XML);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFileSet", "getXmlFiles"));
        }
        return set;
    }

    @NotNull
    public Set<VirtualFilePointer> getCodeConfigurationFiles() {
        LinkedHashSet filePointers = ContainerUtil.newLinkedHashSet();
        for (VirtualFilePointer virtualFilePointer : this.myFiles) {
            PsiFile psiFile;
            VirtualFile virtualFile;
            if (!virtualFilePointer.isValid() || (virtualFile = virtualFilePointer.getFile()) == null || SpringFileSet.isFileType((FileType)StdFileTypes.XML, virtualFile) || SpringFileSet.isFileType((FileType)StdFileTypes.PROPERTIES, virtualFile) || !((psiFile = PsiManager.getInstance((Project)this.getFacet().getModule().getProject()).findFile(virtualFile)) instanceof PsiClassOwner)) continue;
            filePointers.add(virtualFilePointer);
        }
        LinkedHashSet linkedHashSet = filePointers;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFileSet", "getCodeConfigurationFiles"));
        }
        return linkedHashSet;
    }

    private Set<VirtualFilePointer> getConfigFiles(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/spring/facet/SpringFileSet", "getConfigFiles"));
        }
        LinkedHashSet filePointers = ContainerUtil.newLinkedHashSet();
        for (VirtualFilePointer virtualFilePointer : this.myFiles) {
            VirtualFile virtualFile;
            if (!virtualFilePointer.isValid() || (virtualFile = virtualFilePointer.getFile()) == null || !SpringFileSet.isFileType(fileType, virtualFile)) continue;
            filePointers.add(virtualFilePointer);
        }
        return filePointers;
    }

    private static boolean isFileType(@NotNull FileType fileType, @NotNull VirtualFile file) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/spring/facet/SpringFileSet", "isFileType"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/facet/SpringFileSet", "isFileType"));
        }
        return fileType.equals(file.getFileType());
    }

    @NotNull
    public Set<VirtualFilePointer> getPropertiesFiles() {
        Set<VirtualFilePointer> set = this.getConfigFiles((FileType)StdFileTypes.PROPERTIES);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFileSet", "getPropertiesFiles"));
        }
        return set;
    }

    public boolean hasFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        for (VirtualFilePointer virtualFilePointer : this.myFiles) {
            VirtualFile virtualFile;
            if (!virtualFilePointer.isValid() || (virtualFile = virtualFilePointer.getFile()) == null || !file.equals(virtualFile)) continue;
            return true;
        }
        return false;
    }

    protected VirtualFilePointer createVirtualFilePointer(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/spring/facet/SpringFileSet", "createVirtualFilePointer"));
        }
        return VirtualFilePointerManager.getInstance().create(url, (Disposable)this, null);
    }

    public void addFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/facet/SpringFileSet", "addFile"));
        }
        this.addFile(file.getUrl());
    }

    public void addFile(@NonNls String url) {
        if (!StringUtil.isEmptyOrSpaces((String)url)) {
            this.myFiles.add(this.createVirtualFilePointer(url));
            this.myData.addFile(url);
        }
    }

    public void removeFile(VirtualFilePointer file) {
        this.myFiles.remove(file);
        this.myData.removeFile(file.getUrl());
    }

    public void dispose() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpringFileSet set = (SpringFileSet)o;
        if (this.getData() != null ? !this.getData().equals(set.getData()) : set.getData() != null) {
            return false;
        }
        return !(this.getFacet() != null ? !this.getFacet().equals((Object)set.getFacet()) : set.getFacet() != null);
    }

    public int hashCode() {
        int result = this.getFacet() != null ? this.getFacet().hashCode() : 0;
        result = 31 * result + (this.getData() != null ? this.getData().hashCode() : 0);
        return result;
    }
}

