/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi.impl;

import com.intellij.coldFusion.UI.CfmlLookUpItemUtil;
import com.intellij.coldFusion.model.info.CfmlFunctionDescription;
import com.intellij.coldFusion.model.psi.CfmlComponentType;
import com.intellij.coldFusion.model.psi.CfmlFunction;
import com.intellij.coldFusion.model.psi.CfmlParameter;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.coldFusion.model.psi.CfmlRecursiveElementVisitor;
import com.intellij.coldFusion.model.psi.impl.CfmlNamedTagImpl;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import icons.CFMLIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlTagFunctionImpl
extends CfmlNamedTagImpl
implements CfmlFunction,
PlatformIcons {
    public static final String TAG_NAME = "cffunction";

    public CfmlTagFunctionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/coldFusion/model/psi/impl/CfmlTagFunctionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public String getParametersAsString() {
        String string = this.getFunctionInfo().getParametersListPresentableText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlTagFunctionImpl", "getParametersAsString"));
        }
        return string;
    }

    @Override
    @NotNull
    public CfmlParameter[] getParameters() {
        CfmlParameter[] cfmlParameterArray = (CfmlParameter[])this.findChildrenByClass(CfmlParameter.class);
        if (cfmlParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlTagFunctionImpl", "getParameters"));
        }
        return cfmlParameterArray;
    }

    @Override
    @Nullable
    public PsiType getReturnType() {
        String returnTypeString = CfmlPsiUtil.getPureAttributeValue(this, "returntype");
        return returnTypeString != null ? new CfmlComponentType(returnTypeString, this.getContainingFile(), this.getProject()) : null;
    }

    public Icon getIcon(int flags) {
        String access = CfmlPsiUtil.getPureAttributeValue(this, "access");
        if (access == null) {
            return METHOD_ICON;
        }
        access = access.toLowerCase();
        RowIcon baseIcon = new RowIcon(2);
        baseIcon.setIcon(METHOD_ICON, 0);
        if ("private".equals(access)) {
            baseIcon.setIcon(PRIVATE_ICON, 1);
        } else if ("package".equals(access)) {
            baseIcon.setIcon(PACKAGE_LOCAL_ICON, 1);
        } else if ("public".equals(access)) {
            baseIcon.setIcon(PUBLIC_ICON, 1);
        } else if ("remote".equals(access)) {
            baseIcon.setIcon(CFMLIcons.Remote_access, 1);
        }
        return baseIcon;
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    public boolean isTrulyDeclaration() {
        return true;
    }

    @Override
    @NotNull
    public CfmlFunctionDescription getFunctionInfo() {
        CfmlFunctionDescription cfmlFunctionDescription = CfmlLookUpItemUtil.getFunctionDescription(this);
        if (cfmlFunctionDescription == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlTagFunctionImpl", "getFunctionInfo"));
        }
        return cfmlFunctionDescription;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/coldFusion/model/psi/impl/CfmlTagFunctionImpl", "accept"));
        }
        if (visitor instanceof CfmlRecursiveElementVisitor) {
            ((CfmlRecursiveElementVisitor)visitor).visitCfmlFunction(this);
        } else {
            super.accept(visitor);
        }
    }
}

